/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.org.quartz.jobs.ee.jms;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.creeperhost.ftbbackups.org.quartz.JobDataMap;
import net.creeperhost.ftbbackups.org.quartz.jobs.ee.jms.JmsJobException;
import net.creeperhost.ftbbackups.org.quartz.jobs.ee.jms.JmsMessageFactory;

public class JmsHelper {
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String PRINCIPAL = "java.naming.security.principal";
    public static final String CREDENTIALS = "java.naming.security.credentials";
    public static final String JMS_CONNECTION_FACTORY_JNDI = "jms.connection.factory";
    public static final String JMS_DESTINATION_JNDI = "jms.destination";
    public static final String JMS_USER = "jms.user";
    public static final String JMS_PASSWORD = "jms.password";
    public static final String JMS_ACK_MODE = "jms.acknowledge";
    public static final String JMS_USE_TXN = "jms.use.transaction";
    public static final String JMS_MSG_FACTORY_CLASS_NAME = "jms.message.factory.class.name";

    private JmsHelper() {
    }

    public static InitialContext getInitialContext(JobDataMap jobDataMap) throws NamingException {
        String credentials;
        String principal;
        String providerUrl;
        Hashtable<String, String> params = new Hashtable<String, String>(2);
        String initialContextFactory = jobDataMap.getString(INITIAL_CONTEXT_FACTORY);
        if (initialContextFactory != null) {
            params.put(INITIAL_CONTEXT_FACTORY, initialContextFactory);
        }
        if ((providerUrl = jobDataMap.getString(PROVIDER_URL)) != null) {
            params.put(PROVIDER_URL, providerUrl);
        }
        if ((principal = jobDataMap.getString(PRINCIPAL)) != null) {
            params.put(PRINCIPAL, principal);
        }
        if ((credentials = jobDataMap.getString(CREDENTIALS)) != null) {
            params.put(CREDENTIALS, credentials);
        }
        if (params.size() == 0) {
            return new InitialContext();
        }
        return new InitialContext(params);
    }

    public static boolean isDestinationSecure(JobDataMap jobDataMap) {
        String user = jobDataMap.getString(JMS_USER);
        String pw = jobDataMap.getString(JMS_PASSWORD);
        return user != null && pw != null;
    }

    public static void closeResource(Object resource) {
        if (resource == null) {
            return;
        }
        try {
            Method m = resource.getClass().getMethod("close", new Class[0]);
            m.invoke(resource, new Object[0]);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static boolean useTransaction(JobDataMap jobDataMap) {
        return jobDataMap.getBoolean(JMS_USE_TXN);
    }

    public static JmsMessageFactory getMessageFactory(String factoryName) throws JmsJobException {
        try {
            Class<?> clazz = Class.forName(factoryName);
            JmsMessageFactory messageFactory = (JmsMessageFactory)clazz.newInstance();
            return messageFactory;
        }
        catch (ClassNotFoundException e) {
            throw new JmsJobException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new JmsJobException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new JmsJobException(e.getMessage(), e);
        }
    }
}

