/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt.regionfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundMap;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.DoubleTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ListTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;
import net.creeperhost.ftbbackups.de.piegames.nbt.stream.NBTInputStream;
import net.creeperhost.ftbbackups.de.piegames.nbt.stream.NBTOutputStream;

public class Chunk {
    public final int x;
    public final int z;
    public final int timestamp;
    protected final ByteBuffer data;

    public Chunk(int x, int z, int timestamp, ByteBuffer data) {
        if (x < 0 || z < 0 || x >= 32 || z >= 32) {
            throw new IllegalArgumentException("Coordinates must be in range [0..32), but were x=" + x + ", z=" + z + ")");
        }
        this.x = x;
        this.z = z;
        this.timestamp = timestamp;
        if ((data.capacity() & 0xFFF) != 0) {
            throw new IllegalArgumentException("Data buffer size must be multiple of 4096, but is " + data.capacity());
        }
        this.data = Objects.requireNonNull(data);
    }

    Chunk(int x, int z, int timestamp, FileChannel raf, int start, int length) throws IOException {
        if (x < 0 || z < 0 || x >= 32 || z >= 32) {
            throw new IllegalArgumentException("Coordinates must be in range [0..32), but were x=" + x + ", z=" + z + ")");
        }
        this.x = x;
        this.z = z;
        this.timestamp = timestamp;
        this.data = ByteBuffer.allocate(4096 * length);
        raf.read(this.data, 4096 * start);
        this.data.flip();
    }

    public Chunk(int x, int z, int timestamp, Tag<?> data, byte compression) throws IOException {
        if (x < 0 || z < 0 || x >= 32 || z >= 32) {
            throw new IllegalArgumentException("Coordinates must be in range [0..32), but were x=" + x + ", z=" + z + ")");
        }
        this.x = x;
        this.z = z;
        this.timestamp = timestamp;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);){
            try (NBTOutputStream out = new NBTOutputStream(baos, compression);){
                out.writeTag(data);
                out.flush();
            }
            byte[] bytes = baos.toByteArray();
            int sectionLength = (bytes.length + 5) / 4096 + 1;
            this.data = ByteBuffer.allocate(sectionLength * 4096);
            this.data.putInt(bytes.length + 1);
            this.data.put(compression);
            this.data.put(bytes);
            this.data.flip();
        }
    }

    public Chunk(Chunk data, int timestamp) {
        this.x = data.x;
        this.z = data.z;
        this.timestamp = timestamp;
        this.data = data.data;
    }

    public byte getCompression() {
        return this.data.get(4);
    }

    public int getRealLength() {
        return this.data.getInt(0) - 1;
    }

    public int getSectorLength() {
        return (this.getRealLength() + 5) / 4096 + 1;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public NBTInputStream getInputStream() throws IOException {
        return new NBTInputStream(new ByteArrayInputStream(this.data.array(), 5, this.getRealLength()), this.getCompression());
    }

    public CompoundTag readTag() throws IOException {
        try (NBTInputStream nbtIn = this.getInputStream();){
            CompoundTag compoundTag = new CompoundTag("chunk", ((CompoundTag)nbtIn.readTag()).getValue());
            return compoundTag;
        }
    }

    public static int getCurrentTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static int bitsPerIndex(long[] blocks) {
        return blocks.length * 64 / 4096;
    }

    @Deprecated
    public static long extractFromLong(long[] blocks, int i, int bitsPerIndex) {
        return Chunk.extractFromLong1_13(blocks, i, bitsPerIndex);
    }

    public static long extractFromLong1_13(long[] blocks, int i, int bitsPerIndex) {
        int startByteBit = bitsPerIndex * i & 0x3F;
        int startIndex = bitsPerIndex * i >> 6;
        int endIndex = bitsPerIndex * (i + 1) - 1 >> 6;
        long bitMask = -1L >>> 64 - bitsPerIndex;
        if (startIndex == endIndex) {
            return blocks[startIndex] >>> startByteBit & bitMask;
        }
        return (blocks[startIndex] >>> startByteBit | blocks[endIndex] << 64 - startByteBit) & bitMask;
    }

    public static long[] extractFromLong1_16(long[] blocks, int paletteSize) {
        int bitsPerIndex = Math.max(4, 32 - Integer.numberOfLeadingZeros(paletteSize - 1));
        int shortsPerLong = Math.floorDiv(64, bitsPerIndex);
        int mask = (1 << bitsPerIndex) - 1;
        long[] result = new long[4096];
        if (bitsPerIndex == 4) {
            int index = 0;
            for (long l : blocks) {
                result[index++] = l >> 0 & 0xFL;
                result[index++] = l >> 4 & 0xFL;
                result[index++] = l >> 8 & 0xFL;
                result[index++] = l >> 12 & 0xFL;
                result[index++] = l >> 16 & 0xFL;
                result[index++] = l >> 20 & 0xFL;
                result[index++] = l >> 24 & 0xFL;
                result[index++] = l >> 28 & 0xFL;
                result[index++] = l >> 32 & 0xFL;
                result[index++] = l >> 36 & 0xFL;
                result[index++] = l >> 40 & 0xFL;
                result[index++] = l >> 44 & 0xFL;
                result[index++] = l >> 48 & 0xFL;
                result[index++] = l >> 52 & 0xFL;
                result[index++] = l >> 56 & 0xFL;
                result[index++] = l >> 60 & 0xFL;
            }
        } else if (bitsPerIndex == 5) {
            int index = 0;
            for (int i = 0; i < blocks.length - 1; ++i) {
                long l = blocks[i];
                result[index++] = l >> 0 & 0x1FL;
                result[index++] = l >> 5 & 0x1FL;
                result[index++] = l >> 10 & 0x1FL;
                result[index++] = l >> 15 & 0x1FL;
                result[index++] = l >> 20 & 0x1FL;
                result[index++] = l >> 25 & 0x1FL;
                result[index++] = l >> 30 & 0x1FL;
                result[index++] = l >> 35 & 0x1FL;
                result[index++] = l >> 40 & 0x1FL;
                result[index++] = l >> 45 & 0x1FL;
                result[index++] = l >> 50 & 0x1FL;
                result[index++] = l >> 55 & 0x1FL;
            }
            long lastData = blocks[blocks.length - 1];
            switch (result.length - index) {
                case 10: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 9: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 8: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 7: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 6: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 5: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 4: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 3: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 2: {
                    result[index++] = lastData & 0x1FL;
                    lastData >>= 5;
                }
                case 1: {
                    result[index++] = lastData & 0x1FL;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (bitsPerIndex == 6) {
            int index = 0;
            for (int i = 0; i < blocks.length - 1; ++i) {
                long l = blocks[i];
                result[index++] = l >> 0 & 0x3FL;
                result[index++] = l >> 6 & 0x3FL;
                result[index++] = l >> 12 & 0x3FL;
                result[index++] = l >> 18 & 0x3FL;
                result[index++] = l >> 24 & 0x3FL;
                result[index++] = l >> 30 & 0x3FL;
                result[index++] = l >> 36 & 0x3FL;
                result[index++] = l >> 42 & 0x3FL;
                result[index++] = l >> 48 & 0x3FL;
                result[index++] = l >> 54 & 0x3FL;
            }
            long lastData = blocks[blocks.length - 1];
            switch (result.length - index) {
                case 10: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 9: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 8: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 7: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 6: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 5: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 4: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 3: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 2: {
                    result[index++] = lastData & 0x3FL;
                    lastData >>= 6;
                }
                case 1: {
                    result[index++] = lastData & 0x3FL;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else {
            int index = 0;
            for (long l : blocks) {
                for (int s = 0; s < shortsPerLong && index < 4096; ++s) {
                    result[index++] = l & (long)mask;
                    l >>= bitsPerIndex;
                }
            }
        }
        return result;
    }

    public static void moveChunk(CompoundTag level, int sourceX, int sourceZ, int destX, int destZ) {
        CompoundMap map;
        CompoundMap value = level.getValue();
        int diffX = destX - sourceX << 4;
        int diffY = 0;
        int diffZ = destZ - sourceZ << 4;
        value.put(new IntTag("xPos", destX));
        value.put(new IntTag("zPos", destZ));
        Iterator iterator = ((ListTag)value.get("Entities")).getValue().iterator();
        while (iterator.hasNext()) {
            CompoundTag entity = (CompoundTag)iterator.next();
            Object pos = ((ListTag)entity.getValue().get("Pos")).getValue();
            entity.getValue().put(new ListTag<DoubleTag>("Pos", TagType.TAG_DOUBLE, Arrays.asList(new DoubleTag(null, ((DoubleTag)pos.get(0)).getValue() + (double)diffX), new DoubleTag(null, ((DoubleTag)pos.get(1)).getValue() + (double)diffY), new DoubleTag(null, ((DoubleTag)pos.get(2)).getValue() + (double)diffZ))));
        }
        iterator = ((ListTag)value.get("TileEntities")).getValue().iterator();
        while (iterator.hasNext()) {
            CompoundTag tileEntity = (CompoundTag)iterator.next();
            map = tileEntity.getValue();
            map.put(new IntTag("x", ((IntTag)map.get("x")).getValue() + diffX));
            map.put(new IntTag("y", ((IntTag)map.get("y")).getValue() + diffY));
            map.put(new IntTag("z", ((IntTag)map.get("z")).getValue() + diffZ));
        }
        iterator = ((ListTag)value.get("TileTicks")).getValue().iterator();
        while (iterator.hasNext()) {
            CompoundTag tileTick = (CompoundTag)iterator.next();
            map = tileTick.getValue();
            map.put(new IntTag("x", ((IntTag)map.get("x")).getValue() + diffX));
            map.put(new IntTag("y", ((IntTag)map.get("y")).getValue() + diffY));
            map.put(new IntTag("z", ((IntTag)map.get("z")).getValue() + diffZ));
        }
        iterator = ((ListTag)value.get("LiquidTicks")).getValue().iterator();
        while (iterator.hasNext()) {
            CompoundTag liquidTick = (CompoundTag)iterator.next();
            map = liquidTick.getValue();
            map.put(new IntTag("x", ((IntTag)map.get("x")).getValue() + diffX));
            map.put(new IntTag("y", ((IntTag)map.get("y")).getValue() + diffY));
            map.put(new IntTag("z", ((IntTag)map.get("z")).getValue() + diffZ));
        }
    }
}

