/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt;

import java.util.HashMap;
import java.util.Map;
import net.creeperhost.ftbbackups.de.piegames.nbt.ByteArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ByteTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.CompoundTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.DoubleTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.EndTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.FloatTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ListTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.LongArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.LongTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ShortArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ShortTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.StringTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;

public enum TagType {
    TAG_END(EndTag.class, "TAG_End", 0, 0),
    TAG_BYTE(ByteTag.class, "TAG_Byte", 1, 1),
    TAG_SHORT(ShortTag.class, "TAG_Short", 2, 2),
    TAG_INT(IntTag.class, "TAG_Int", 3, 4),
    TAG_LONG(LongTag.class, "TAG_Long", 4, 8),
    TAG_FLOAT(FloatTag.class, "TAG_Float", 5, 4),
    TAG_DOUBLE(DoubleTag.class, "TAG_Double", 6, 8),
    TAG_BYTE_ARRAY(ByteArrayTag.class, "TAG_Byte_Array", 7, 1),
    TAG_STRING(StringTag.class, "TAG_String", 8, -1),
    TAG_LIST(ListTag.class, "TAG_List", 9, -1),
    TAG_COMPOUND(CompoundTag.class, "TAG_Compound", 10, -1),
    TAG_INT_ARRAY(IntArrayTag.class, "TAG_Int_Array", 11, 4),
    TAG_LONG_ARRAY(LongArrayTag.class, "TAG_Long_Array", 12, 8),
    TAG_SHORT_ARRAY(ShortArrayTag.class, "TAG_Short_Array", 100, 2);

    private static final Map<Class<? extends Tag<?>>, TagType> BY_CLASS;
    private static final Map<String, TagType> BY_NAME;
    private static final TagType[] BY_ID;
    private final Class<? extends Tag<?>> tagClass;
    private final String typeName;
    private final int id;
    private final int bytes;

    private TagType(Class<? extends Tag<?>> tagClass, String typeName, int id, int bytes) {
        this.tagClass = tagClass;
        this.typeName = typeName;
        this.id = id;
        this.bytes = bytes;
        if (this.id > BaseData.maxId) {
            BaseData.maxId = this.id;
        }
    }

    public Class<? extends Tag<?>> getTagClass() {
        return this.tagClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getId() {
        return this.id;
    }

    public int getSize() {
        return this.bytes;
    }

    public static TagType getByTagClass(Class<? extends Tag<?>> clazz) {
        TagType ret = BY_CLASS.get(clazz);
        if (ret == null) {
            throw new IllegalArgumentException("Tag type " + clazz + " is unknown!");
        }
        return ret;
    }

    public static TagType getByTypeName(String typeName) {
        TagType ret = BY_NAME.get(typeName);
        if (ret == null) {
            throw new IllegalArgumentException("Tag type " + typeName + " is unknown!");
        }
        return ret;
    }

    public static TagType getById(int id) {
        if (id >= 0 && id < BY_ID.length) {
            TagType ret = BY_ID[id];
            if (ret == null) {
                throw new IllegalArgumentException("Tag type id " + id + " is unknown!");
            }
            return ret;
        }
        throw new IndexOutOfBoundsException("Tag type id " + id + " is out of bounds!");
    }

    static {
        BY_CLASS = new HashMap();
        BY_NAME = new HashMap<String, TagType>();
        BY_ID = new TagType[BaseData.maxId + 1];
        for (TagType type : TagType.values()) {
            BY_CLASS.put(type.getTagClass(), type);
            BY_NAME.put(type.getTypeName(), type);
            TagType.BY_ID[type.getId()] = type;
        }
    }

    private static class BaseData {
        private static int maxId = 0;

        private BaseData() {
        }
    }
}

