/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt;

import java.util.Optional;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;

public final class LongTag
extends Tag<Long> {
    private long value;

    public LongTag(String name, long value) {
        super(TagType.TAG_LONG, name);
        this.value = value;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public void setValue(Long value) {
        this.value = value;
    }

    @Override
    public Optional<LongTag> getAsLongTag() {
        return Optional.of(this);
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Long" + append + ": " + this.value;
    }

    @Override
    public LongTag clone() {
        return new LongTag(this.getName(), this.value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongTag other = (LongTag)obj;
        return this.value == other.value;
    }
}

