/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt;

import java.util.Optional;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;

public final class IntTag
extends Tag<Integer> {
    private int value;

    public IntTag(String name, int value) {
        super(TagType.TAG_INT, name);
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public Optional<IntTag> getAsIntTag() {
        return Optional.of(this);
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Int" + append + ": " + this.value;
    }

    @Override
    public IntTag clone() {
        return new IntTag(this.getName(), this.value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntTag other = (IntTag)obj;
        return this.value == other.value;
    }
}

