/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.nbt;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Optional;
import net.creeperhost.ftbbackups.de.piegames.nbt.IntArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.LongArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.ShortArrayTag;
import net.creeperhost.ftbbackups.de.piegames.nbt.Tag;
import net.creeperhost.ftbbackups.de.piegames.nbt.TagType;

public final class ByteArrayTag
extends Tag<byte[]> {
    private byte[] value;

    public ByteArrayTag(String name, byte[] value) {
        super(TagType.TAG_BYTE_ARRAY, name);
        this.value = value;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] value) {
        this.value = value;
    }

    public short[] getShortArrayValue() {
        ShortBuffer buffer = ByteBuffer.wrap(this.value).asShortBuffer();
        short[] array = new short[buffer.remaining()];
        buffer.get(array);
        return array;
    }

    public int[] getIntArrayValue() {
        IntBuffer buffer = ByteBuffer.wrap(this.value).asIntBuffer();
        int[] array = new int[buffer.remaining()];
        buffer.get(array);
        return array;
    }

    public long[] getLongArrayValue() {
        LongBuffer buffer = ByteBuffer.wrap(this.value).asLongBuffer();
        long[] array = new long[buffer.remaining()];
        buffer.get(array);
        return array;
    }

    @Override
    public Optional<ByteArrayTag> getAsByteArrayTag() {
        return Optional.of(this);
    }

    @Override
    public Optional<IntArrayTag> getAsIntArrayTag() {
        return Optional.of(new IntArrayTag(this.getName(), this.getIntArrayValue()));
    }

    @Override
    public Optional<LongArrayTag> getAsLongArrayTag() {
        return Optional.of(new LongArrayTag(this.getName(), this.getLongArrayValue()));
    }

    @Override
    public Optional<ShortArrayTag> getAsShortArrayTag() {
        return Optional.of(new ShortArrayTag(this.getName(), this.getShortArrayValue()));
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        for (byte b : this.value) {
            String hexDigits = Integer.toHexString(b).toUpperCase();
            if (hexDigits.length() == 1) {
                hex.append("0");
            }
            hex.append(hexDigits).append(" ");
        }
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Byte_Array" + append + ": " + hex.toString();
    }

    @Override
    public ByteArrayTag clone() {
        byte[] clonedArray = this.cloneArray(this.value);
        return new ByteArrayTag(this.getName(), clonedArray);
    }

    private byte[] cloneArray(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int length = byteArray.length;
        byte[] newArray = new byte[length];
        System.arraycopy(byteArray, 0, newArray, 0, length);
        return newArray;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayTag other = (ByteArrayTag)obj;
        return Arrays.equals(this.value, other.value);
    }
}

