/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.standalone;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftDimension;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BiomeColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.BlockColorMap;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RegionRenderer;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RegionShader;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RenderSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.GsonFireBuilder;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.net.dongilu.gson.GsonJava8TypeAdapterFactory;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.picocli.CommandLine;
import net.creeperhost.ftbbackups.de.piegames.blockmap.standalone.DeserializeNullChecker;
import net.creeperhost.ftbbackups.de.piegames.blockmap.standalone.PostProcessing;
import net.creeperhost.ftbbackups.de.piegames.blockmap.standalone.ServerSettings;
import net.creeperhost.ftbbackups.de.piegames.blockmap.standalone.VersionProvider;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.LevelMetadata;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.RegionFolder;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.ServerMetadata;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

@CommandLine.Command(name="blockmap", versionProvider=VersionProvider.class, synopsisSubcommandLabel="COMMAND", subcommands={CommandRender.class, CommandServer.class}, footerHeading="%n", footer={"This is the command line interface of blockmap. To access the GUI (if installed), run `blockmap-gui`."})
public class CommandLineMain
implements Callable<Integer> {
    private static Logger log = null;
    public static final Gson GSON = new GsonFireBuilder().enableExposeMethodParam().registerPostProcessor(ServerSettings.class, new DeserializeNullChecker()).registerPostProcessor(ServerSettings.RegionFolderSettings.class, new DeserializeNullChecker()).createGsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonJava8TypeAdapterFactory()).registerTypeHierarchyAdapter(Path.class, (Object)new TypeAdapter<Path>(){

        public void write(JsonWriter out, Path value) throws IOException {
            out.value(value.toString());
        }

        public Path read(JsonReader in) throws IOException {
            return Paths.get(in.nextString(), new String[0]);
        }
    }).disableHtmlEscaping().setPrettyPrinting().create();
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, description={"Print version information and exit."})
    boolean versionRequested;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Print this help message and exit"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"--verbose", "-v"}, description={"Be chatty"})
    boolean verbose;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    private static void checkLogger() {
        if (log == null) {
            log = LogManager.getLogger(CommandLineMain.class);
        }
    }

    public void runAll() {
        if (this.verbose) {
            Configurator.setRootLevel((Level)Level.DEBUG);
        }
    }

    @Override
    public Integer call() {
        this.runAll();
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required subcommand");
    }

    public static int mainWithoutQuit(String ... args) {
        System.setProperty("joml.format", "false");
        return new CommandLine(new CommandLineMain()).execute(args);
    }

    public static void main(String ... args) {
        System.exit(CommandLineMain.mainWithoutQuit(args));
    }

    @CommandLine.Command(name="render-many", sortOptions=false, description={"Render multiple worlds using a configuration file for usage in servers"}, footerHeading="%n", footer={"Please don't forget that you can use global options too, which can be listed through `blockmap --help`. These have to be put before the render command."})
    public static class CommandServer
    implements Callable<Integer> {
        @CommandLine.ParentCommand
        private CommandLineMain main;
        @CommandLine.Parameters(index="0", paramLabel="CONFIG", description={"Path to the config.json"})
        private Path input;

        @Override
        public Integer call() {
            ServerSettings settings;
            this.main.runAll();
            CommandLineMain.checkLogger();
            try {
                settings = (ServerSettings)GSON.fromJson(new String(Files.readAllBytes(this.input.toAbsolutePath())), ServerSettings.class);
            }
            catch (JsonParseException | IOException e) {
                log.error("Could not parse the settings file", e);
                return 2;
            }
            ServerMetadata serverMetadata = settings.serverMetadata.orElse(new ServerMetadata());
            serverMetadata.levels = new ArrayList<ServerMetadata.ServerLevel>(settings.worlds.length);
            for (ServerSettings.RegionFolderSettings folderSettings : settings.worlds) {
                RegionFolder.CachedRegionFolder cached;
                RegionFolder.WorldRegionFolder world;
                Path inputRegion;
                log.info("Rendering world " + folderSettings.name);
                serverMetadata.levels.add(new ServerMetadata.ServerLevel(folderSettings.name, URLEncoder.encode(folderSettings.name, Charset.defaultCharset()).replace("+", "%20") + "/rendered.json.gz"));
                RegionRenderer renderer = new RegionRenderer(folderSettings.renderSettings);
                Path input = folderSettings.inputDir;
                if (Files.isDirectory(input, new LinkOption[0])) {
                    if (!Files.exists(input.resolve("level.dat"), new LinkOption[0])) {
                        log.warn("World folders normally contain a file called `level.dat`. Sure you got the right folder?");
                    }
                } else if (input.getFileName().toString().equals("level.dat")) {
                    input = input.getParent();
                } else {
                    log.error("Input path must either point to a folder or to the `level.dat`, but was " + input.toAbsolutePath());
                    return 2;
                }
                if (!Files.exists(inputRegion = input.resolve(folderSettings.dimension.getRegionPath()), new LinkOption[0])) {
                    log.error("Specified region folder does not exist");
                    return 2;
                }
                if (!Files.isDirectory(inputRegion, new LinkOption[0])) {
                    log.error("Specified region folder is not a directory");
                    return 2;
                }
                try {
                    world = RegionFolder.WorldRegionFolder.load(inputRegion, renderer, folderSettings.dimension == MinecraftDimension.NETHER);
                    cached = RegionFolder.CachedRegionFolder.create(world, !folderSettings.force, settings.outputDir.resolve(folderSettings.name));
                }
                catch (IOException e) {
                    log.error("Could not load region folder", (Throwable)e);
                    return 1;
                }
                for (Vector2ic pos : world.listRegions()) {
                    if (!PostProcessing.inBounds(pos.x(), folderSettings.renderSettings.minX, folderSettings.renderSettings.maxX) || !PostProcessing.inBounds(pos.y(), folderSettings.renderSettings.minZ, folderSettings.renderSettings.maxZ)) continue;
                    try {
                        cached.render(pos);
                    }
                    catch (IOException e) {
                        log.error("Could not render region file", (Throwable)e);
                    }
                }
                Set<String> online = serverMetadata.onlinePlayers.orElse(Collections.emptySet());
                LevelMetadata levelMetadata = LevelMetadata.loadFromWorld(input, folderSettings.dimension);
                if (settings.pinSettings.isPresent()) {
                    ServerSettings.PinSettings pinSettings = settings.pinSettings.get();
                    levelMetadata = pinSettings.apply(levelMetadata, online);
                    pinSettings.showStructures.ifPresent(cached::filterStructures);
                }
                world.setPins(levelMetadata);
                try {
                    cached.save();
                }
                catch (IOException e) {
                    log.error("Could not save the rendered world", (Throwable)e);
                    return 1;
                }
            }
            try (BufferedWriter writer = Files.newBufferedWriter(settings.outputDir.resolve("index.json"), new OpenOption[0]);){
                GSON.toJson((Object)serverMetadata, ServerMetadata.class, (Appendable)writer);
            }
            catch (IOException e) {
                log.error("Could not save the index file");
                return 1;
            }
            return 0;
        }
    }

    @CommandLine.Command(name="render", sortOptions=false, description={"Render a folder containing region files to another folder through the command line interface"}, footerHeading="%n", footer={"Please don't forget that you can use global options too, which can be listed through `blockmap --help`. These have to be put before the render command."})
    public static class CommandRender
    implements Callable<Integer> {
        @CommandLine.ParentCommand
        private CommandLineMain main;
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Print this help message and exit"})
        boolean usageHelpRequested;
        @CommandLine.Option(names={"--output", "-o"}, description={"The location of the output images. Must not be a file. Non-existant folders will be created."}, paramLabel="<FOLDER>", defaultValue="./", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
        private Path output;
        @CommandLine.Parameters(index="0", paramLabel="INPUT", description={"Path to the world data. This should be a folder containing a level.dat. A path to the level.dat itself is valid too."})
        private Path input;
        @CommandLine.Option(names={"-c", "--color-map"}, paramLabel="{DEFAULT|CAVES|NO_FOLIAGE|OCEAN_GROUND|RAILS}", description={"Load a built-in color map."}, defaultValue="DEFAULT")
        private BlockColorMap.InternalColorMap colorMap;
        @CommandLine.Option(names={"-s", "--shader"}, paramLabel="{FLAT|RELIEF|BIOMES|HEIGHTMAP}", description={"The height shading to use in post processing."}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, defaultValue="RELIEF")
        private RegionShader.DefaultShader shader;
        @CommandLine.Option(names={"-d", "--dim", "--dimension"}, paramLabel="{OVERWORLD|NETHER|END}", defaultValue="OVERWORLD", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, description={"The dimension of the world to render."})
        private MinecraftDimension dimension;
        @CommandLine.Option(names={"--min-Y", "--min-height"}, description={"Don't draw blocks lower than this height."}, defaultValue="0")
        private int minY;
        @CommandLine.Option(names={"--max-Y", "--max-height"}, description={"Don't draw blocks higher than this height."}, defaultValue="255")
        private int maxY;
        @CommandLine.Option(names={"--min-X"}, description={"Don't draw blocks to the east of this coordinate."}, defaultValue="-2147483648")
        private int minX;
        @CommandLine.Option(names={"--max-X"}, description={"Don't draw blocks to the west of this coordinate."}, defaultValue="2147483647")
        private int maxX;
        @CommandLine.Option(names={"--min-Z"}, description={"Don't draw blocks to the north of this coordinate."}, defaultValue="-2147483648")
        private int minZ;
        @CommandLine.Option(names={"--max-Z"}, description={"Don't draw blocks to the south of this coordinate."}, defaultValue="2147483647")
        private int maxZ;
        @CommandLine.Option(names={"-l", "--lazy"}, description={"Don't render region files if there is already an up to date. This saves time when rendering the same world regularly with the same settings."}, hidden=true)
        @Deprecated
        private boolean lazy;
        @CommandLine.Option(names={"-f", "--force"}, description={"Re-render region files even if they are up to date (based on their timestamp)"})
        private boolean force;
        @CommandLine.Option(names={"-p", "--pins"}, description={"Load pin data from the world. This requires the use of the --dimension option"})
        private boolean pins;
        @CommandLine.Option(names={"--create-tile-html"}, description={"Generate a tiles.html in the output directory that will show all rendered images ona mapin your browsed."})
        private boolean createHtml;
        @CommandLine.Option(names={"--create-big-image"}, description={"Merge all rendered images into a single file. May require a lot of RAM."})
        private boolean createBigPic;

        @Override
        public Integer call() {
            RegionFolder.CachedRegionFolder cached;
            RegionFolder.WorldRegionFolder world;
            this.main.runAll();
            CommandLineMain.checkLogger();
            RenderSettings settings = new RenderSettings();
            settings.minX = this.minX;
            settings.maxX = this.maxX;
            settings.minY = this.minY;
            settings.maxY = this.maxY;
            settings.minZ = this.minZ;
            settings.maxZ = this.maxZ;
            settings.blockColors = this.colorMap.getColorMap();
            settings.biomeColors = BiomeColorMap.loadDefault();
            settings.regionShader = this.shader.getShader();
            RegionRenderer renderer = new RegionRenderer(settings);
            Path input = this.input;
            if (Files.isDirectory(input, new LinkOption[0])) {
                if (!Files.exists(input.resolve("level.dat"), new LinkOption[0])) {
                    log.warn("World folders normally contain a file called `level.dat`. Sure you got the right folder?");
                }
            } else if (input.getFileName().toString().equals("level.dat")) {
                input = input.getParent();
            } else {
                log.error("Input path must either point to a folder or to the `level.dat`, but was " + input.toAbsolutePath());
                return 2;
            }
            Path inputRegion = input.resolve(this.dimension.getRegionPath());
            log.debug("Input: " + input.normalize().toAbsolutePath());
            log.debug("Output: " + this.output.normalize().toAbsolutePath());
            if (!Files.exists(inputRegion, new LinkOption[0])) {
                log.error("Specified region folder does not exist");
                return 2;
            }
            if (!Files.isDirectory(inputRegion, new LinkOption[0])) {
                log.error("Specified region folder is not a directory");
                return 2;
            }
            try {
                world = RegionFolder.WorldRegionFolder.load(inputRegion, renderer, this.dimension == MinecraftDimension.NETHER);
                cached = RegionFolder.CachedRegionFolder.create(world, !this.force, this.output);
            }
            catch (IOException e) {
                log.error("Could not load region folder", (Throwable)e);
                return 1;
            }
            for (Vector2ic pos : world.listRegions()) {
                if (!PostProcessing.inBounds(pos.x(), settings.minX, settings.maxX) || !PostProcessing.inBounds(pos.y(), settings.minZ, settings.maxZ)) continue;
                try {
                    cached.render(pos);
                }
                catch (IOException e) {
                    log.error("Could not render region file", (Throwable)e);
                }
            }
            if (this.pins) {
                world.setPins(LevelMetadata.loadFromWorld(input, this.dimension));
            }
            try {
                cached.save();
            }
            catch (IOException e) {
                log.error("Could not save the rendered world", (Throwable)e);
                return 1;
            }
            if (this.createBigPic) {
                return PostProcessing.createBigImage(cached, this.output, settings);
            }
            if (this.createHtml) {
                return PostProcessing.createTileHtml(cached, this.output, settings);
            }
            return 0;
        }
    }
}

