/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AnnotationInspector<T extends AccessibleObject, M> {
    private final ConcurrentMap<Class, ConcurrentMap<Class<? extends Annotation>, Collection<M>>> cache = new ConcurrentHashMap<Class, ConcurrentMap<Class<? extends Annotation>, Collection<M>>>();

    public Collection<M> getAnnotatedMembers(Class clazz, Class<? extends Annotation> annotation) {
        if (clazz != null) {
            Collection<M> members = this.getFromCache(clazz, annotation);
            if (members != null) {
                return members;
            }
            members = this.getFromCache(clazz, annotation);
            if (members == null) {
                LinkedHashSet<M> memberList = new LinkedHashSet<M>();
                for (AccessibleObject accessibleObject : this.getDeclaredMembers(clazz)) {
                    if (!accessibleObject.isAnnotationPresent(annotation)) continue;
                    accessibleObject.setAccessible(true);
                    memberList.add(this.map(accessibleObject));
                }
                memberList.addAll(this.getAnnotatedMembers(clazz.getSuperclass(), annotation));
                for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
                    memberList.addAll(this.getAnnotatedMembers((Class)annotatedElement, annotation));
                }
                ConcurrentHashMap newAnnotationMap = new ConcurrentHashMap();
                ConcurrentMap<Class<? extends Annotation>, LinkedHashSet<M>> storedAnnotationMap = this.cache.putIfAbsent(clazz, newAnnotationMap);
                storedAnnotationMap = storedAnnotationMap == null ? newAnnotationMap : storedAnnotationMap;
                storedAnnotationMap.put(annotation, memberList);
                return memberList;
            }
        }
        return Collections.emptyList();
    }

    protected abstract T[] getDeclaredMembers(Class var1);

    protected abstract M map(T var1);

    private Collection<M> getFromCache(Class clazz, Class<? extends Annotation> annotation) {
        Collection methods;
        Map annotationMap = (Map)this.cache.get(clazz);
        if (annotationMap != null && (methods = (Collection)annotationMap.get(annotation)) != null) {
            return methods;
        }
        return null;
    }
}

