/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RFC3339DateFormat
extends DateFormat {
    private static final Pattern TIMEZONE_PATTERN = Pattern.compile("(.*)([+-][0-9][0-9])\\:?([0-9][0-9])$");
    private static final Pattern MILLISECONDS_PATTERN = Pattern.compile("(.*)\\.([0-9]+)(.*)");
    private static final Pattern DATE_ONLY_PATTERN = Pattern.compile("^[0-9]{1,4}-[0-1][0-9]-[0-3][0-9]$");
    private final SimpleDateFormat rfc3339Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final SimpleDateFormat rfc3339Formatter;
    private final boolean serializeTime;

    public RFC3339DateFormat(TimeZone serializationTimezone, boolean serializeTime) {
        this.rfc3339Formatter = serializeTime ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
        this.serializeTime = serializeTime;
        this.rfc3339Formatter.setTimeZone(serializationTimezone);
    }

    public RFC3339DateFormat(TimeZone serializationTimezone) {
        this(serializationTimezone, true);
    }

    public RFC3339DateFormat(boolean serializeTime) {
        this(TimeZone.getTimeZone("UTC"), serializeTime);
    }

    public RFC3339DateFormat() {
        this(true);
    }

    private String generateTimezone(long time, TimeZone serializationTimezone) {
        if (serializationTimezone.getOffset(time) == 0) {
            return "Z";
        }
        int offset = (int)((long)serializationTimezone.getOffset(time) / 1000L);
        int hours = offset / 3600;
        int minutes = Math.abs((offset - hours * 3600) / 60);
        String sign = hours >= 0 ? "+" : "-";
        return sign + String.format("%02d", Math.abs(hours)) + ":" + String.format("%02d", minutes);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        StringBuffer formatted = new StringBuffer();
        formatted.append(this.rfc3339Formatter.format(date).toString());
        if (this.serializeTime) {
            long time = date.getTime();
            if (time % 1000L != 0L) {
                String fraction = Long.toString(time % 1000L);
                formatted.append("." + fraction);
            }
            String timezoneStr = this.generateTimezone(time, this.rfc3339Formatter.getTimeZone());
            formatted.append(timezoneStr);
        }
        return formatted;
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        Matcher matcher;
        if (DATE_ONLY_PATTERN.matcher(source).matches()) {
            source = source + "T00:00:00-0000";
        } else if (source.charAt(10) == 't') {
            source = source.substring(0, 10) + "T" + source.substring(12);
        }
        long millis = 0L;
        if (source.contains(".")) {
            matcher = MILLISECONDS_PATTERN.matcher(source);
            String millisStr = matcher.replaceAll("$2");
            millis = Long.parseLong(millisStr);
            source = matcher.replaceAll("$1") + matcher.replaceAll("$3");
        }
        source = source.endsWith("Z") || source.endsWith("z") ? source.substring(0, source.length() - 1) + "-0000" : ((matcher = TIMEZONE_PATTERN.matcher(source)).matches() ? matcher.replaceAll("$1") + matcher.replaceAll("$2") + matcher.replaceAll("$3") : source + "-0000");
        try {
            Date res = this.rfc3339Parser.parse(source);
            if (millis > 0L) {
                res = new Date(res.getTime() + millis);
            }
            pos.setIndex(source.length());
            return res;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

