/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.color;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftVersion;
import net.creeperhost.ftbbackups.de.piegames.blockmap.color.Color;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.Block;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.GsonFireBuilder;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.TypeSelector;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.Exclude;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.ExposeMethodParam;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.ExposeMethodResult;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.PostDeserialize;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.PostSerialize;

public class BlockColorMap {
    public static final Gson GSON = new GsonFireBuilder().enableHooks(BlockColor.class).enableHooks(BlockColorMap.class).enableExposeMethodParam().enableExposeMethodResult().enableExcludeByAnnotation().registerTypeSelector(StateColors.class, new TypeSelector<StateColors>(){

        @Override
        public Class<? extends StateColors> getClassForElement(JsonElement readElement) {
            return readElement.getAsJsonObject().has("color") ? SingleStateColors.class : NormalStateColors.class;
        }
    }).createGsonBuilder().serializeNulls().registerTypeAdapter(Color.class, Color.ADAPTER).disableHtmlEscaping().create();
    protected boolean discardTop;
    protected Map<String, StateColors> blockColors;
    protected transient BlockColor airColor;
    protected static final transient StateColors missing = new SingleStateColors(BlockColor.MISSING){

        @Override
        public boolean hasColor(BitSet state) {
            return false;
        }
    };

    public BlockColorMap(Map<String, StateColors> blockColors) {
        this(blockColors, false);
    }

    public BlockColorMap(Map<String, StateColors> blockColors, boolean discardTop) {
        this.blockColors = Objects.requireNonNull(blockColors);
        this.discardTop = discardTop;
    }

    public BlockColor getBlockColor(String blockName, BitSet blockState) {
        return this.blockColors.getOrDefault(blockName, missing).getColor(blockState);
    }

    public BlockColor getBlockColor(String blockName, Supplier<BitSet> blockState) {
        return this.blockColors.getOrDefault(blockName, missing).getColor(blockState);
    }

    public boolean hasBlockColor(String blockName, BitSet blockState) {
        return this.blockColors.containsKey(blockName) && this.blockColors.get(blockName).hasColor(blockState);
    }

    @PostDeserialize
    private void postDeserialize() {
        HashMap<String, StateColors> blockColors = new HashMap<String, StateColors>(this.blockColors.size() * 2, 0.51f);
        blockColors.putAll(this.blockColors);
        this.blockColors = blockColors;
        this.airColor = this.getBlockColor("minecraft:air", Block.STATE_NONE);
    }

    public BlockColor getAirColor() {
        return this.airColor;
    }

    public boolean isCaveView() {
        return this.discardTop;
    }

    public Map<String, StateColors> getBlockColors() {
        return new HashMap<String, StateColors>(this.blockColors);
    }

    public int hashCode() {
        return Objects.hash(this.blockColors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockColorMap other = (BlockColorMap)obj;
        return Objects.equals(this.blockColors, other.blockColors);
    }

    public static BlockColorMap load(Reader reader) {
        return (BlockColorMap)GSON.fromJson(reader, BlockColorMap.class);
    }

    public static BlockColorMap loadInternal(String name, MinecraftVersion version) {
        try {
            return BlockColorMap.load(new InputStreamReader(BlockColorMap.class.getResourceAsStream("/block-colors-" + name + "-" + version.fileSuffix + ".json")));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Did not find internal color map " + name + " for version " + version.versionName + " (resource file 'block-colors-" + name + "-" + version.fileSuffix + ".json')", e);
        }
    }

    public static interface StateColors {
        public BlockColor getColor(BitSet var1);

        default public BlockColor getColor(Supplier<BitSet> state) {
            return this.getColor(state.get());
        }

        public boolean hasColor(BitSet var1);
    }

    public static class BlockColor {
        public static final BlockColor MISSING = new BlockColor(Color.MISSING, false, false, false, false);
        public static final BlockColor TRANSPARENT = new BlockColor(Color.TRANSPARENT, false, false, false, true);
        public Color color;
        @Exclude
        public boolean isGrass;
        @Exclude
        public boolean isFoliage;
        @Exclude
        public boolean isWater;
        @Exclude
        public boolean isTranslucent;

        public BlockColor() {
        }

        public BlockColor(Color color, boolean isGrass, boolean isFoliage, boolean isWater, boolean isTranslucent) {
            this.color = color;
            this.isGrass = isGrass;
            this.isFoliage = isFoliage;
            this.isWater = isWater;
            this.isTranslucent = isTranslucent;
        }

        @PostDeserialize
        private void postDeserialize(JsonElement src, Gson gson) {
            JsonObject obj = src.getAsJsonObject();
            int isGFWT = obj.has("isGFWT") ? obj.getAsJsonPrimitive("isGFWT").getAsInt() : 0;
            this.isGrass = (isGFWT & 8) != 0;
            this.isFoliage = (isGFWT & 4) != 0;
            this.isWater = (isGFWT & 2) != 0;
            this.isTranslucent = (isGFWT & 1) != 0;
        }

        @PostSerialize
        private void preSerialize(JsonElement src, Gson gson) {
            int isGFWT = this.isGFWT();
            if (isGFWT != 0) {
                src.getAsJsonObject().addProperty("isGFWT", (Number)isGFWT);
            }
        }

        public String toString() {
            return "BlockColor [color=" + this.color + ", isGrass=" + this.isGrass + ", isFoliage=" + this.isFoliage + ", isWater=" + this.isWater + ", isTranslucent=" + this.isTranslucent + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
            result = 31 * result + this.isGFWT();
            return result;
        }

        int isGFWT() {
            return (this.isGrass ? 8 : 0) | (this.isFoliage ? 4 : 0) | (this.isWater ? 2 : 0) | (this.isTranslucent ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockColor other = (BlockColor)obj;
            return this.equals(other);
        }

        public boolean equals(BlockColor other) {
            if (this.isGFWT() != other.isGFWT()) {
                return false;
            }
            return !(this.color == null ? other.color != null : !this.color.equals(other.color));
        }
    }

    public static class SingleStateColors
    extends BlockColor
    implements StateColors {
        private SingleStateColors() {
        }

        public SingleStateColors(BlockColor color) {
            super(color.color, color.isGrass, color.isFoliage, color.isWater, color.isTranslucent);
        }

        @Override
        public BlockColor getColor(BitSet state) {
            return this;
        }

        @Override
        public BlockColor getColor(Supplier<BitSet> state) {
            return this;
        }

        @Override
        public boolean hasColor(BitSet state) {
            return true;
        }
    }

    public static class NormalStateColors
    implements StateColors {
        @Exclude
        Map<BitSet, BlockColor> blockColors;

        private NormalStateColors() {
        }

        public NormalStateColors(Map<BitSet, BlockColor> blockColors) {
            this.blockColors = Objects.requireNonNull(blockColors);
        }

        @Override
        public BlockColor getColor(BitSet state) {
            return this.blockColors.getOrDefault(state, BlockColor.MISSING);
        }

        @Override
        public boolean hasColor(BitSet state) {
            return this.blockColors.containsKey(state);
        }

        @ExposeMethodResult(value="blockColors")
        Map<String, BlockColor> getColorsRaw() {
            HashMap<String, BlockColor> blockColors = new HashMap<String, BlockColor>();
            this.blockColors.forEach((k, v) -> blockColors.put(Base64.getEncoder().encodeToString(k.toByteArray()), (BlockColor)v));
            return blockColors;
        }

        @ExposeMethodParam(value="blockColors")
        void setColorsRaw(Map<String, BlockColor> blockColors) {
            this.blockColors = new HashMap<BitSet, BlockColor>(blockColors.size() * 2, 0.51f);
            blockColors.forEach((k, v) -> this.blockColors.put(BitSet.valueOf(Base64.getDecoder().decode((String)k)), (BlockColor)v));
        }

        public Map<BitSet, BlockColor> getColors() {
            return new HashMap<BitSet, BlockColor>(this.blockColors);
        }

        public int hashCode() {
            return Objects.hash(this.blockColors);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NormalStateColors other = (NormalStateColors)obj;
            return Objects.equals(this.blockColors, other.blockColors);
        }
    }

    public static enum InternalColorMap {
        DEFAULT("default"),
        CAVES("caves"),
        NO_FOLIAGE("foliage"),
        OCEAN_GROUND("water"),
        X_RAY("x-ray"),
        RAILS("rails");

        private String fileName;

        private InternalColorMap(String fileName) {
            this.fileName = Objects.requireNonNull(fileName);
        }

        public Map<MinecraftVersion, BlockColorMap> getColorMap() {
            return Arrays.stream(MinecraftVersion.values()).collect(Collectors.toMap(Function.identity(), version -> BlockColorMap.loadInternal(this.fileName, version)));
        }
    }
}

