/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.creeperhost.ftbbackups.FTBBackups;
import net.creeperhost.ftbbackups.blue.endless.jankson.Jankson;
import net.creeperhost.ftbbackups.blue.endless.jankson.JsonElement;
import net.creeperhost.ftbbackups.blue.endless.jankson.JsonObject;
import net.creeperhost.ftbbackups.config.ConfigData;
import org.apache.commons.io.IOUtils;

public class Config {
    private static AtomicReference<ConfigData> data = new AtomicReference();
    private static File lastFile;
    private static boolean loaded;
    private static Jankson gson;
    public static AtomicReference<WatchService> watcher;

    public static void loadFromFile(File file) {
        lastFile = file;
        try {
            JsonObject jObject = gson.load(file);
            ConfigData newData = gson.fromJson(jObject, ConfigData.class);
            if (newData != data.get()) {
                data.set(newData);
                if (!Config.isLoaded()) {
                    FileWriter tileWriter = new FileWriter(file);
                    tileWriter.write(Config.saveConfig());
                    tileWriter.close();
                }
                loaded = true;
            }
        }
        catch (Exception e) {
            FTBBackups.LOGGER.error("En error occurred while reading config file, Loading defaults", (Throwable)e);
            data.set(new ConfigData());
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void saveConfigToFile(File file) {
        try (FileOutputStream configOut = new FileOutputStream(file);){
            IOUtils.write((String)Config.saveConfig(), (OutputStream)configOut, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static ConfigData cached() {
        return data.get();
    }

    public static synchronized ConfigData update(ConfigData _data) {
        data.set(_data);
        return data.get();
    }

    public static synchronized boolean reload() {
        if (lastFile != null) {
            Config.loadFromFile(lastFile);
            return true;
        }
        return false;
    }

    public static String saveConfig() {
        ConfigData conf = data.get();
        JsonElement elem = gson.toJson(conf);
        return elem.toJson(true, true);
    }

    public static void init(File file) {
        if (lastFile == null) {
            lastFile = file;
        }
        try {
            try {
                Runnable configWatcher = () -> {
                    try {
                        if (watcher.get() == null) {
                            watcher.set(FileSystems.getDefault().newWatchService());
                            lastFile.toPath().getParent().register(watcher.get(), StandardWatchEventKinds.ENTRY_MODIFY);
                        }
                        WatchKey checker = watcher.get().take();
                        for (WatchEvent<?> event : checker.pollEvents()) {
                            if (FTBBackups.isShutdown) {
                                return;
                            }
                            Path changed = (Path)event.context();
                            if (!changed.endsWith(lastFile.getName()) || !Config.isLoaded() || !Config.reload()) continue;
                            FTBBackups.LOGGER.info("Config at " + lastFile.getAbsolutePath() + " has changed, reloaded!");
                        }
                        checker.reset();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                };
                if (FTBBackups.configWatcherExecutorService.isShutdown()) {
                    FTBBackups.configWatcherExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("FTB Backups Config Watcher %d").setDaemon(true).build());
                }
                FTBBackups.configWatcherExecutorService.scheduleAtFixedRate(configWatcher, 0L, 10L, TimeUnit.SECONDS);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
            if (!file.exists()) {
                ConfigData configData = new ConfigData();
                data.set(configData);
                FileWriter tileWriter = new FileWriter(file);
                tileWriter.write(Config.saveConfig());
                tileWriter.close();
            } else {
                Config.loadFromFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        gson = Jankson.builder().build();
        watcher = new AtomicReference();
    }
}

