/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.blue.endless.jankson;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.creeperhost.ftbbackups.blue.endless.jankson.JsonElement;
import net.creeperhost.ftbbackups.blue.endless.jankson.JsonNull;
import net.creeperhost.ftbbackups.blue.endless.jankson.JsonObject;
import net.creeperhost.ftbbackups.blue.endless.jankson.api.DeserializationException;
import net.creeperhost.ftbbackups.blue.endless.jankson.api.DeserializerFunction;
import net.creeperhost.ftbbackups.blue.endless.jankson.api.Marshaller;
import net.creeperhost.ftbbackups.blue.endless.jankson.api.SyntaxError;
import net.creeperhost.ftbbackups.blue.endless.jankson.impl.AnnotatedElement;
import net.creeperhost.ftbbackups.blue.endless.jankson.impl.ElementParserContext;
import net.creeperhost.ftbbackups.blue.endless.jankson.impl.MarshallerImpl;
import net.creeperhost.ftbbackups.blue.endless.jankson.impl.ObjectParserContext;
import net.creeperhost.ftbbackups.blue.endless.jankson.impl.ParserContext;

public class Jankson {
    private Deque<ParserFrame<?>> contextStack = new ArrayDeque();
    private JsonObject root;
    private int line = 0;
    private int column = 0;
    private int withheldCodePoint = -1;
    private Marshaller marshaller = MarshallerImpl.getFallback();
    private boolean allowBareRootObject = false;
    private int retries = 0;
    private SyntaxError delayedError = null;
    private AnnotatedElement rootElement;

    private Jankson(Builder builder) {
    }

    @Nonnull
    public JsonObject load(String s) throws SyntaxError {
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes(Charset.forName("UTF-8")));
        try {
            return this.load(in);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    public JsonObject load(File f) throws IOException, SyntaxError {
        try (FileInputStream in = new FileInputStream(f);){
            JsonObject jsonObject = this.load(in);
            return jsonObject;
        }
    }

    @Nonnull
    public JsonObject load(InputStream in) throws IOException, SyntaxError {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        this.withheldCodePoint = -1;
        this.root = null;
        this.push(new ObjectParserContext(this.allowBareRootObject), it -> {
            this.root = it;
        });
        while (this.root == null) {
            if (this.delayedError != null) {
                throw this.delayedError;
            }
            if (this.withheldCodePoint != -1) {
                ++this.retries;
                if (this.retries > 25) {
                    throw new IOException("Parser got stuck near line " + this.line + " column " + this.column);
                }
                this.processCodePoint(this.withheldCodePoint);
                continue;
            }
            int inByte = reader.read();
            if (inByte == -1) {
                while (!this.contextStack.isEmpty()) {
                    ParserFrame<?> frame = this.contextStack.pop();
                    try {
                        ((ParserFrame)frame).context.eof();
                        if (!((ParserFrame)frame).context.isComplete()) continue;
                        frame.supply();
                    }
                    catch (SyntaxError error) {
                        error.setStartParsing(((ParserFrame)frame).startLine, ((ParserFrame)frame).startCol);
                        error.setEndParsing(this.line, this.column);
                        throw error;
                    }
                }
                if (this.root == null) {
                    this.root = new JsonObject();
                    this.root.marshaller = this.marshaller;
                }
                return this.root;
            }
            this.processCodePoint(inByte);
        }
        return this.root;
    }

    @Nonnull
    public JsonElement loadElement(String s) throws SyntaxError {
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes(Charset.forName("UTF-8")));
        try {
            return this.loadElement(in);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    public JsonElement loadElement(File f) throws IOException, SyntaxError {
        try (FileInputStream in = new FileInputStream(f);){
            JsonElement jsonElement = this.loadElement(in);
            return jsonElement;
        }
    }

    @Nonnull
    public JsonElement loadElement(InputStream in) throws IOException, SyntaxError {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        this.withheldCodePoint = -1;
        this.rootElement = null;
        this.push(new ElementParserContext(), it -> {
            this.rootElement = it;
        });
        while (this.rootElement == null) {
            if (this.delayedError != null) {
                throw this.delayedError;
            }
            if (this.withheldCodePoint != -1) {
                ++this.retries;
                if (this.retries > 25) {
                    throw new IOException("Parser got stuck near line " + this.line + " column " + this.column);
                }
                this.processCodePoint(this.withheldCodePoint);
                continue;
            }
            int inByte = reader.read();
            if (inByte == -1) {
                while (!this.contextStack.isEmpty()) {
                    ParserFrame<?> frame = this.contextStack.pop();
                    try {
                        ((ParserFrame)frame).context.eof();
                        if (!((ParserFrame)frame).context.isComplete()) continue;
                        frame.supply();
                    }
                    catch (SyntaxError error) {
                        error.setStartParsing(((ParserFrame)frame).startLine, ((ParserFrame)frame).startCol);
                        error.setEndParsing(this.line, this.column);
                        throw error;
                    }
                }
                if (this.rootElement == null) {
                    return JsonNull.INSTANCE;
                }
                return this.rootElement.getElement();
            }
            this.processCodePoint(inByte);
        }
        return this.rootElement.getElement();
    }

    public <T> T fromJson(JsonObject obj, Class<T> clazz) {
        return this.marshaller.marshall(clazz, (JsonElement)obj);
    }

    public <T> T fromJson(String json, Class<T> clazz) throws SyntaxError {
        JsonObject obj = this.load(json);
        return this.fromJson(obj, clazz);
    }

    public <T> T fromJsonCarefully(String json, Class<T> clazz) throws SyntaxError, DeserializationException {
        JsonObject obj = this.load(json);
        return this.fromJsonCarefully(obj, clazz);
    }

    public <T> T fromJsonCarefully(JsonObject obj, Class<T> clazz) throws DeserializationException {
        return this.marshaller.marshallCarefully(clazz, obj);
    }

    public <T> JsonElement toJson(T t) {
        return this.marshaller.serialize(t);
    }

    public <T> JsonElement toJson(T t, Marshaller alternateMarshaller) {
        return alternateMarshaller.serialize(t);
    }

    private void processCodePoint(int codePoint) throws SyntaxError {
        ParserFrame<?> frame = this.contextStack.peek();
        if (frame == null) {
            throw new IllegalStateException("Parser problem! The ParserContext stack underflowed! (line " + this.line + ", col " + this.column + ")");
        }
        try {
            if (frame.context().isComplete()) {
                this.contextStack.pop();
                frame.supply();
                frame = this.contextStack.peek();
            }
        }
        catch (SyntaxError error) {
            error.setStartParsing(((ParserFrame)frame).startLine, ((ParserFrame)frame).startCol);
            error.setEndParsing(this.line, this.column);
            throw error;
        }
        try {
            boolean consumed = ((ParserFrame)frame).context.consume(codePoint, this);
            if (((ParserFrame)frame).context.isComplete()) {
                this.contextStack.pop();
                frame.supply();
            }
            if (consumed) {
                this.withheldCodePoint = -1;
                this.retries = 0;
            } else {
                this.withheldCodePoint = codePoint;
            }
        }
        catch (SyntaxError error) {
            error.setStartParsing(((ParserFrame)frame).startLine, ((ParserFrame)frame).startCol);
            error.setEndParsing(this.line, this.column);
            throw error;
        }
        ++this.column;
        if (codePoint == 10) {
            ++this.line;
            this.column = 0;
        }
    }

    public <T> void push(ParserContext<T> t, Consumer<T> consumer) {
        ParserFrame<T> frame = new ParserFrame<T>(t, consumer);
        ((ParserFrame)frame).startLine = this.line;
        ((ParserFrame)frame).startCol = this.column;
        this.contextStack.push(frame);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void throwDelayed(SyntaxError syntaxError) {
        syntaxError.setEndParsing(this.line, this.column);
        this.delayedError = syntaxError;
    }

    private static class ParserFrame<T> {
        private ParserContext<T> context;
        private Consumer<T> consumer;
        private int startLine = 0;
        private int startCol = 0;

        public ParserFrame(ParserContext<T> context, Consumer<T> consumer) {
            this.context = context;
            this.consumer = consumer;
        }

        public ParserContext<T> context() {
            return this.context;
        }

        public void supply() throws SyntaxError {
            this.consumer.accept(this.context.getResult());
        }
    }

    public static class Builder {
        MarshallerImpl marshaller = new MarshallerImpl();
        boolean allowBareRootObject = false;

        @Deprecated
        public <T> Builder registerTypeAdapter(Class<T> clazz, Function<JsonObject, T> adapter) {
            this.marshaller.registerTypeAdapter(clazz, adapter);
            return this;
        }

        @Deprecated
        public <T> Builder registerPrimitiveTypeAdapter(Class<T> clazz, Function<Object, T> adapter) {
            this.marshaller.register(clazz, adapter);
            return this;
        }

        public <T> Builder registerSerializer(Class<T> clazz, BiFunction<T, Marshaller, JsonElement> serializer) {
            this.marshaller.registerSerializer(clazz, serializer);
            return this;
        }

        public <A, B> Builder registerDeserializer(Class<A> sourceClass, Class<B> targetClass, DeserializerFunction<A, B> function) {
            this.marshaller.registerDeserializer(sourceClass, targetClass, function);
            return this;
        }

        public <T> Builder registerTypeFactory(Class<T> clazz, Supplier<T> factory) {
            this.marshaller.registerTypeFactory(clazz, factory);
            return this;
        }

        public Builder allowBareRootObject() {
            this.allowBareRootObject = true;
            return this;
        }

        public Jankson build() {
            Jankson result = new Jankson(this);
            result.marshaller = this.marshaller;
            result.allowBareRootObject = this.allowBareRootObject;
            return result;
        }
    }
}

