/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.cap;

import net.gigabit101.shrink.utils.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyStorageItemImpl
extends EnergyStorage {
    private final ItemStack stack;

    public EnergyStorageItemImpl(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.stack = stack;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyStored = this.getEnergyStored();
        int energyReceived = Math.min(this.capacity - energyStored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyStored = this.getEnergyStored();
        int energyExtracted = Math.min(energyStored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.setEnergyStored(energyStored - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.stack.m_41784_().m_128451_("Energy");
    }

    public void setEnergyStored(int amount) {
        this.stack.m_41784_().m_128405_("Energy", MathHelper.clamp(amount, 0, this.capacity));
    }
}

