/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.memory;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ImageButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTab;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsContainer;

public class MemorySettingsTab
extends SettingsTab<MemorySettingsContainer> {
    private static final TextureBlitData ICON = new TextureBlitData(GuiHelper.ICONS, Dimension.SQUARE_256, new UV(128, 32), Dimension.SQUARE_16);
    private static final TextureBlitData SELECT_ALL_SLOTS_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(16, 80), Dimension.SQUARE_16);
    public static final ButtonDefinition SELECT_ALL_SLOTS = new ButtonDefinition(Dimension.SQUARE_16, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, SELECT_ALL_SLOTS_FOREGROUND, new Component[]{Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsButton("select_all_slots"))});
    private static final TextureBlitData UNSELECT_ALL_SLOTS_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(48, 80), Dimension.SQUARE_16);
    public static final ButtonDefinition UNSELECT_ALL_SLOTS = new ButtonDefinition(Dimension.SQUARE_16, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, UNSELECT_ALL_SLOTS_FOREGROUND, new Component[]{Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsButton("unselect_all_slots"))});
    private static final TextureBlitData SAVE_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(240, 16), Dimension.SQUARE_16);
    public static final ButtonDefinition SAVE_TEMPLATE = new ButtonDefinition(Dimension.SQUARE_16, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, SAVE_FOREGROUND, new Component[]{Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsButton("save_template"))});
    private static final TextureBlitData LOAD_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(240, 32), Dimension.SQUARE_16);
    public static final ButtonDefinition LOAD_TEMPLATE = new ButtonDefinition(Dimension.SQUARE_16, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, LOAD_FOREGROUND, new Component[]{Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsButton("load_template"))});
    private final Button loadTemplateButton;
    private final Button saveTemplateButton;

    public MemorySettingsTab(final MemorySettingsContainer container, Position position, SettingsScreen screen) {
        super(container, position, screen, (Component)Component.m_237115_((String)TranslationHelper.INSTANCE.translSettings("memory")), (List<Component>)new ImmutableList.Builder().add((Object)Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsTooltip("memory"))).addAll(TranslationHelper.INSTANCE.getTranslatedLines(TranslationHelper.INSTANCE.translSettingsTooltip("memory") + "_detail", null, ChatFormatting.GRAY)).build(), (List<Component>)new ImmutableList.Builder().add((Object)Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsTooltip("memory"))).addAll(TranslationHelper.INSTANCE.getTranslatedLines(TranslationHelper.INSTANCE.translSettingsTooltip("memory") + "_open_detail", null, ChatFormatting.GRAY)).build(), onTabIconClicked -> new ImageButton(new Position(position.x() + 1, position.y() + 4), Dimension.SQUARE_16, ICON, (IntConsumer)onTabIconClicked));
        this.addHideableChild(new Button(new Position(this.x + 3, this.y + 24), SELECT_ALL_SLOTS, button -> container.selectAllSlots()));
        this.addHideableChild(new Button(new Position(this.x + 21, this.y + 24), UNSELECT_ALL_SLOTS, button -> container.unselectAllSlots()));
        this.addHideableChild(new ToggleButton<Boolean>(new Position(this.x + 39, this.y + 24), ButtonDefinitions.MATCH_NBT, button -> container.setIgnoreNbt(!container.ignoresNbt()), () -> !container.ignoresNbt()));
        this.saveTemplateButton = new Button(new Position(this.x + 12, this.y + 44), SAVE_TEMPLATE, button -> container.saveTemplate()){

            public boolean m_6050_(double mouseX, double mouseY, double delta) {
                container.scrollSaveSlot(delta > 0.0);
                MemorySettingsTab.this.setSaveTooltip();
                return true;
            }
        };
        this.setSaveTooltip();
        this.addHideableChild(this.saveTemplateButton);
        this.loadTemplateButton = new Button(new Position(this.x + 30, this.y + 44), LOAD_TEMPLATE, button -> container.loadTemplate()){

            public boolean m_6050_(double mouseX, double mouseY, double delta) {
                container.scrollLoadSlot(delta > 0.0);
                MemorySettingsTab.this.setLoadTooltip();
                return true;
            }
        };
        this.setLoadTooltip();
        this.addHideableChild(this.loadTemplateButton);
    }

    private void setLoadTooltip() {
        if (((MemorySettingsContainer)this.getSettingsContainer()).getLoadSlot() == -1) {
            this.loadTemplateButton.setTooltip(List.of(Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsButton("load_template.no_save")).m_130940_(ChatFormatting.RED)));
        } else {
            this.loadTemplateButton.setTooltip(List.of(Component.m_237110_((String)TranslationHelper.INSTANCE.translSettingsButton("load_template"), (Object[])new Object[]{Component.m_237113_((String)String.valueOf(((MemorySettingsContainer)this.getSettingsContainer()).getLoadSlot())).m_130940_(ChatFormatting.GREEN)}), Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsButton("load_template.controls")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY})));
        }
    }

    private void setSaveTooltip() {
        this.saveTemplateButton.setTooltip(List.of(Component.m_237110_((String)TranslationHelper.INSTANCE.translSettingsButton("save_template"), (Object[])new Object[]{Component.m_237113_((String)String.valueOf(((MemorySettingsContainer)this.getSettingsContainer()).getSaveSlot())).m_130940_(ChatFormatting.GREEN)}), Component.m_237115_((String)TranslationHelper.INSTANCE.translSettingsButton("save_template.controls")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY})));
    }

    @Override
    public Optional<Integer> getSlotOverlayColor(int slotNumber) {
        return Optional.empty();
    }

    @Override
    public void handleSlotClick(Slot slot, int mouseButton) {
        if (mouseButton == 0) {
            ((MemorySettingsContainer)this.getSettingsContainer()).selectSlot(slot.f_40219_);
        } else if (mouseButton == 1) {
            ((MemorySettingsContainer)this.getSettingsContainer()).unselectSlot(slot.f_40219_);
        }
    }

    @Override
    public ItemStack getItemDisplayOverride(int slotNumber) {
        ItemStack templatesMemorizedStack;
        if (this.loadTemplateButton.isHovered() && !(templatesMemorizedStack = ((MemorySettingsContainer)this.getSettingsContainer()).getSelectedTemplatesMemorizedStack(slotNumber)).m_41619_()) {
            return templatesMemorizedStack;
        }
        return ((MemorySettingsContainer)this.getSettingsContainer()).getMemorizedStack(slotNumber);
    }

    @Override
    public void drawSlotStackOverlay(PoseStack poseStack, Slot slot) {
        if (((MemorySettingsContainer)this.getSettingsContainer()).isSlotSelected(slot.getSlotIndex()) || this.isShowingTemplateItemInSlot(slot)) {
            this.drawMemorizedStackOverlay(poseStack, slot);
        }
    }

    private boolean isShowingTemplateItemInSlot(Slot slot) {
        return this.loadTemplateButton.isHovered() && !((MemorySettingsContainer)this.getSettingsContainer()).getSelectedTemplatesMemorizedStack(slot.getSlotIndex()).m_41619_();
    }

    private void drawMemorizedStackOverlay(PoseStack poseStack, Slot slot) {
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiHelper.GUI_CONTROLS);
        this.m_93228_(poseStack, slot.f_40220_, slot.f_40221_, 77, 0, 16, 16);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }
}

