/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.init;

import com.blakebr0.cucumber.crafting.conditions.EnableableCondition;
import com.blakebr0.cucumber.crafting.conditions.FeatureFlagCondition;
import com.blakebr0.cucumber.crafting.recipe.ShapedNoMirrorRecipe;
import com.blakebr0.cucumber.crafting.recipe.ShapedTagRecipe;
import com.blakebr0.cucumber.crafting.recipe.ShapedTransferDamageRecipe;
import com.blakebr0.cucumber.crafting.recipe.ShapelessTagRecipe;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public final class ModRecipeSerializers {
    public static final DeferredRegister<RecipeSerializer<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"cucumber");
    public static final RegistryObject<RecipeSerializer<?>> CRAFTING_SHAPED_NO_MIRROR = ModRecipeSerializers.register("shaped_no_mirror", ShapedNoMirrorRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> CRAFTING_SHAPED_TRANSFER_DAMAGE = ModRecipeSerializers.register("shaped_transfer_damage", ShapedTransferDamageRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> CRAFTING_SHAPED_TAG = ModRecipeSerializers.register("shaped_tag", ShapedTagRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> CRAFTING_SHAPELESS_TAG = ModRecipeSerializers.register("shapeless_tag", ShapelessTagRecipe.Serializer::new);

    @SubscribeEvent
    public void onRegisterSerializers(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, (T registry) -> {
            CraftingHelper.register((IConditionSerializer)EnableableCondition.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)FeatureFlagCondition.Serializer.INSTANCE);
        });
    }

    private static RegistryObject<RecipeSerializer<?>> register(String name, Supplier<RecipeSerializer<?>> serializer) {
        return REGISTRY.register(name, serializer);
    }
}

