/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.items;

import de.maxhenkel.easy_piglins.corelib.CachedMap;
import de.maxhenkel.easy_piglins.corelib.client.CustomRendererItem;
import de.maxhenkel.easy_piglins.corelib.client.ItemRenderer;
import de.maxhenkel.easypiglins.Main;
import de.maxhenkel.easypiglins.items.render.PiglinItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PiglinItem
extends CustomRendererItem {
    private CachedMap<ItemStack, Piglin> cachedPiglins = new CachedMap(10000L);
    private String translationKey = EntityType.f_20511_.m_20675_();

    public PiglinItem() {
        super(new Item.Properties().m_41487_(1));
        DispenserBlock.m_52672_((ItemLike)this, (source, stack) -> {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos blockpos = source.m_7961_().m_121945_(direction);
            ServerLevel world = source.m_7727_();
            Piglin piglin = this.getPiglin((Level)world, stack);
            piglin.m_19890_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, direction.m_122435_(), 0.0f);
            world.m_7967_((Entity)piglin);
            stack.m_41774_(1);
            return stack;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemRenderer createItemRenderer() {
        return new PiglinItemRenderer();
    }

    protected String m_41467_() {
        return this.translationKey;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (!blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_()) {
            blockpos = blockpos.m_121945_(direction);
        }
        Piglin piglin = this.getPiglin(world, itemstack);
        piglin.m_6034_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5);
        if (world.m_7967_((Entity)piglin)) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack stack) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return super.m_7626_(stack);
        }
        return this.getPiglinFast((Level)world, stack).m_5446_();
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player) || world.f_46443_) {
            return;
        }
        if (!((Boolean)Main.SERVER_CONFIG.piglinInventorySounds.get()).booleanValue()) {
            return;
        }
        if (world.m_46467_() % 20L != 0L) {
            return;
        }
        if (world.f_46441_.m_188503_(20) == 0) {
            Player playerEntity = (Player)entity;
            playerEntity.m_6330_(SoundEvents.f_12239_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    public void setPiglin(ItemStack stack, Piglin piglin) {
        CompoundTag compound = stack.m_41698_("Piglin");
        piglin.m_7380_(compound);
    }

    public Piglin getPiglin(Level world, ItemStack stack) {
        CompoundTag compound = stack.m_41737_("Piglin");
        if (compound == null) {
            compound = new CompoundTag();
        }
        Piglin piglin = new Piglin(EntityType.f_20511_, world);
        piglin.m_7378_(compound);
        piglin.f_20916_ = 0;
        piglin.f_20885_ = 0.0f;
        piglin.f_20886_ = 0.0f;
        return piglin;
    }

    public Piglin getPiglinFast(Level world, ItemStack stack) {
        return this.cachedPiglins.get(stack, () -> this.getPiglin(world, stack));
    }
}

