/*
 * Decompiled with CFR 0.152.
 */
package tfar.unstabletools.crafting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.unstabletools.JSONUtils2;

public class ConversionManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Block, Block> conversionMap = new HashMap<Block, Block>();
    private boolean someRecipesErrored;
    public static final String BLOCK_CONVS = "block_conversions";

    public ConversionManager() {
        super(GSON, BLOCK_CONVS);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.someRecipesErrored = false;
        this.conversionMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.m_135815_().startsWith("_")) continue;
            try {
                Pair<Block, Block> blockPair = ConversionManager.deserializeConversion(resourcelocation, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"));
                if (blockPair == null) {
                    LOGGER.info("Skipping loading conversion {} as it is empty", (Object)resourcelocation);
                    continue;
                }
                this.conversionMap.put((Block)blockPair.getFirst(), (Block)blockPair.getSecond());
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Parsing error loading conversion {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        LOGGER.info("Loaded {} block conversions", (Object)this.conversionMap.size());
    }

    public static Pair<Block, Block> deserializeConversion(ResourceLocation recipeId, JsonObject json) {
        if (json.size() == 0) {
            return null;
        }
        Block s1 = JSONUtils2.getBlock(json, "from");
        Block s2 = JSONUtils2.getBlock(json, "to");
        return Pair.of((Object)s1, (Object)s2);
    }

    public Map<Block, Block> getConversionMap() {
        return this.conversionMap;
    }
}

