/*
 * Decompiled with CFR 0.152.
 */
package tfar.unstabletools.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public static ForgeConfigSpec.ConfigValue<List<String>> allowed_containers;
        public static ForgeConfigSpec.BooleanValue cursed_earth_integration;
        public static ForgeConfigSpec.IntValue timer;
        public static ForgeConfigSpec.IntValue uses;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(Registry.f_122863_.m_7981_((Object)MenuType.f_39968_).toString());
            strings.add("fastbench:fastbench");
            builder.push("general");
            allowed_containers = builder.comment("Allowed Container Types").translation("text.unstabletools.config.allowed_containers").define("containers", strings, List.class::isInstance);
            cursed_earth_integration = builder.comment("Enable integration with Cursed Earth").translation("text.unstabletools.config.cursed_earth_integration").define("cursed earth integration", true);
            timer = builder.comment("Time before explosion in ticks").translation("text.unstabletools.config.timer").defineInRange("timer", 200, 1, Integer.MAX_VALUE);
            uses = builder.comment("Number of uses when charged").translation("text.unstabletools.config.uses").defineInRange("uses", 256, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

