/*
 * Decompiled with CFR 0.152.
 */
package tfar.unstabletools;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import tfar.unstabletools.crafting.Config;
import tfar.unstabletools.crafting.ConversionManager;
import tfar.unstabletools.datagen.Datagen;
import tfar.unstabletools.init.ModBlocks;
import tfar.unstabletools.init.ModItems;
import tfar.unstabletools.init.ModRecipeSerializer;
import tfar.unstabletools.item.tools.ItemUnstableShears;

@Mod(value="unstabletools")
public class UnstableTools {
    public static UnstableTools instance;
    public static final String MODID = "unstabletools";
    public static final Tier UNSTABLE;
    public static final ArmorMaterial UNSTABLE_ARMOR;
    public static CreativeModeTab creativeTab;
    public final ConversionManager manager = new ConversionManager();

    public UnstableTools() {
        instance = this;
        MinecraftForge.EVENT_BUS.addListener(this::onDrops);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(Datagen::gather);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
    }

    public static void onBlockDrops(Level worldIn, BlockPos pos, ItemStack stackToSpawn, Entity entity, ItemStack stack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41720_() instanceof ItemUnstableShears) {
                player.m_36356_(stackToSpawn);
            }
        }
    }

    private void reload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this.manager);
    }

    private void onDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof WitherBoss && event.getSource().m_7639_() instanceof Player) {
            ItemStack itemStackToDrop = new ItemStack((ItemLike)ModItems.inactive_division_sign);
            event.getDrops().add(new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), itemStackToDrop));
        }
    }

    static {
        UNSTABLE = new UnstableTier();
        UNSTABLE_ARMOR = new UnstableArmorMaterial();
        creativeTab = new CreativeModeTab(MODID){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ModItems.unstable_pickaxe);
            }
        };
    }

    public static class UnstableTier
    implements Tier {
        public int m_6609_() {
            return 0;
        }

        public float m_6624_() {
            return 8.0f;
        }

        public float m_6631_() {
            return 8.0f;
        }

        public int m_6604_() {
            return 4;
        }

        public int m_6601_() {
            return 25;
        }

        @Nonnull
        public Ingredient m_6282_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.unstable_ingot});
        }
    }

    public static class UnstableArmorMaterial
    implements ArmorMaterial {
        private static int[] array = new int[]{4, 7, 9, 4};

        public int m_7366_(@Nonnull EquipmentSlot slotIn) {
            return 0;
        }

        public int m_7365_(@Nonnull EquipmentSlot slot) {
            return array[slot.m_20749_()];
        }

        public int m_6646_() {
            return 25;
        }

        @Nonnull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11673_;
        }

        @Nonnull
        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.unstable_ingot});
        }

        @Nonnull
        public String m_6082_() {
            return "unstable";
        }

        public float m_6651_() {
            return 5.0f;
        }

        public float m_6649_() {
            return 1.0f;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerBlock(RegisterEvent event) {
            event.register(Registry.f_122901_, new ResourceLocation(UnstableTools.MODID, "unstable_block"), () -> ModBlocks.unstable_block);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_ingot"), () -> ModItems.unstable_ingot);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_shears"), () -> ModItems.unstable_shears);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_block"), () -> ModItems.unstable_block);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_axe"), () -> ModItems.unstable_axe);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_shovel"), () -> ModItems.unstable_shovel);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_pickaxe"), () -> ModItems.unstable_pickaxe);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_sword"), () -> ModItems.unstable_sword);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_hoe"), () -> ModItems.unstable_hoe);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_fishing_rod"), () -> ModItems.unstable_fishing_rod);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_bow"), () -> ModItems.unstable_bow);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_helmet"), () -> ModItems.unstable_helmet);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_chestplate"), () -> ModItems.unstable_chestplate);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_leggings"), () -> ModItems.unstable_leggings);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "unstable_boots"), () -> ModItems.unstable_boots);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "inactive_division_sign"), () -> ModItems.inactive_division_sign);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "division_sign"), () -> ModItems.division_sign);
            event.register(Registry.f_122904_, new ResourceLocation(UnstableTools.MODID, "stable_division_sign"), () -> ModItems.stable_division_sign);
            event.register(Registry.f_122915_, new ResourceLocation(UnstableTools.MODID, "division"), () -> ModRecipeSerializer.division);
        }
    }
}

