/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.registration.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.moddingx.libx.registration.MultiRegisterable;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class EnumObjects<E extends Enum<E>, T>
implements MultiRegisterable<T> {
    private final T defaultValue;
    private final E[] keys;
    private final Map<E, T> map;

    public EnumObjects(Class<E> cls, Function<E, T> factory) {
        if (!cls.isEnum()) {
            throw new IllegalStateException("Non-enum class in EnumObjects: " + cls.getName());
        }
        Object defaultValue = null;
        this.map = new HashMap<E, T>();
        this.keys = (Enum[])cls.getEnumConstants();
        if (this.keys.length == 0) {
            throw new IllegalStateException("EnumObjects cannot be used with empty enums.");
        }
        for (E e : this.keys) {
            T t = factory.apply(e);
            if (defaultValue == null) {
                defaultValue = t;
            }
            this.map.put(e, t);
        }
        this.defaultValue = Objects.requireNonNull(defaultValue, "EnumObjects cannot be used with empty enums.");
    }

    public T get(E key) {
        return this.map.getOrDefault(key, this.defaultValue);
    }

    public T random(Random random) {
        return this.map.get(this.keys[random.nextInt(this.keys.length)]);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, MultiRegisterable.EntryCollector<T> builder) {
        for (Map.Entry<E, T> entry : this.map.entrySet()) {
            builder.registerNamed(((Enum)entry.getKey()).name().toLowerCase(Locale.ROOT), entry.getValue());
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void initTracking(RegistrationContext ctx, Registerable.TrackingCollector builder) throws ReflectiveOperationException {
        ForgeRegistry registry;
        ResourceKey registryKey = ctx.registry().orElse(null);
        ForgeRegistry forgeRegistry = registry = registryKey == null ? null : RegistryManager.ACTIVE.getRegistry(registryKey.m_135782_());
        if (registry != null) {
            for (E key : this.keys) {
                builder.runNamed(registry, ((Enum)key).name().toLowerCase(Locale.ROOT), value -> this.map.put(key, value));
            }
        }
    }
}

