/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigCategory;
import codechicken.lib.config.ConfigCategoryImpl;
import codechicken.lib.config.parser.ConfigSerializer;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFile.class);
    private final String rootName;
    @Nullable
    private Path path;
    @Nullable
    private ConfigSerializer serializer;

    public ConfigFile(String rootName) {
        this.rootName = rootName;
    }

    public ConfigFile path(Path path) {
        this.path = path;
        this.serializer = ConfigFile.pickForExtension(path);
        return this;
    }

    public ConfigFile serializer(ConfigSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public ConfigCategory load() {
        if (this.path == null) {
            throw new IllegalStateException("Path has not been set.");
        }
        if (this.serializer == null) {
            throw new IllegalStateException("Serializer was not automatically detected from file extension.");
        }
        ConfigCategoryImpl rootTag = new ConfigCategoryImpl(this.rootName, null){

            @Override
            public void save() {
                if (this.isDirty()) {
                    try {
                        ConfigFile.this.serializer.save(ConfigFile.this.path, this);
                    }
                    catch (IOException ex) {
                        LOGGER.error("Failed to save config file! {}", (Object)ConfigFile.this.path, (Object)ex);
                    }
                    this.clearDirty();
                }
            }
        };
        if (Files.exists(this.path, new LinkOption[0])) {
            try {
                this.serializer.parse(this.path, rootTag);
            }
            catch (Throwable ex) {
                rootTag.clear();
                rootTag.clearDirty();
                Path backup = ConfigFile.moveToBackup(this.path);
                LOGGER.warn("Failed to load config {} - Backing up to '{}' and generating a new one.", new Object[]{this.path, backup, ex});
            }
        }
        return rootTag;
    }

    @Nullable
    @VisibleForTesting
    static ConfigSerializer pickForExtension(Path path) {
        String ext;
        return switch (ext = FilenameUtils.getExtension((String)path.getFileName().toString())) {
            case "cfg" -> ConfigSerializer.LEGACY;
            case "json" -> ConfigSerializer.JSON;
            case "toml" -> ConfigSerializer.TOML;
            default -> null;
        };
    }

    @Nullable
    @VisibleForTesting
    static Path moveToBackup(Path path) {
        try {
            String fName = path.getFileName().toString();
            String ext = FilenameUtils.getExtension((String)fName);
            int curr = ext.startsWith("bak") ? Integer.parseInt(ext.substring(3)) : 0;
            int next = curr + 1;
            Path newFile = path.resolveSibling((ext.startsWith("bak") ? FilenameUtils.removeExtension((String)fName) : fName) + ".bak" + next);
            if (next == 6) {
                Files.delete(path);
                return null;
            }
            if (Files.exists(newFile, new LinkOption[0])) {
                ConfigFile.moveToBackup(newFile);
            }
            Files.move(path, newFile, new CopyOption[0]);
            return newFile;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to move config file.", ex);
        }
    }
}

