/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbteamdimensions.FTBTeamDimensions;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record PrebuiltStructure(ResourceLocation id, ResourceLocation structureLocation, String name, String author, Optional<BlockPos> spawnOverride, ResourceLocation structureSetId, int height, ResourceLocation dimensionType, ResourceLocation previewImage, int displayOrder) {
    private final ResourceLocation previewImage;
    public static final ResourceLocation DEFAULT_PREVIEW = FTBTeamDimensions.rl("default");
    public static final ResourceLocation FALLBACK_IMAGE = FTBTeamDimensions.rl("textures/fallback.png");
    public static final ResourceLocation DEFAULT_DIMENSION_TYPE = FTBTeamDimensions.rl("default");
    public static final ResourceLocation DEFAULT_STRUCTURE_SET = FTBTeamDimensions.rl("default");
    public static final Codec<PrebuiltStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(PrebuiltStructure::id), (App)ResourceLocation.f_135803_.fieldOf("structure").forGetter(PrebuiltStructure::structureLocation), (App)Codec.STRING.fieldOf("name").forGetter(PrebuiltStructure::name), (App)Codec.STRING.optionalFieldOf("author", (Object)"FTB Team").forGetter(PrebuiltStructure::author), (App)BlockPos.f_121852_.optionalFieldOf("spawn_override").forGetter(PrebuiltStructure::spawnOverride), (App)ResourceLocation.f_135803_.optionalFieldOf("structure_set", (Object)DEFAULT_STRUCTURE_SET).forGetter(PrebuiltStructure::structureSetId), (App)Codec.INT.optionalFieldOf("height", (Object)64).forGetter(PrebuiltStructure::height), (App)ResourceLocation.f_135803_.optionalFieldOf("dimension_type", (Object)DEFAULT_DIMENSION_TYPE).forGetter(PrebuiltStructure::dimensionType), (App)ResourceLocation.f_135803_.optionalFieldOf("preview_image", (Object)DEFAULT_PREVIEW).forGetter(PrebuiltStructure::previewImage), (App)Codec.INT.optionalFieldOf("display_order", (Object)0).forGetter(PrebuiltStructure::displayOrder)).apply((Applicative)instance, PrebuiltStructure::new));

    public static Optional<PrebuiltStructure> fromJson(JsonElement element) {
        return CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(error -> FTBTeamDimensions.LOGGER.error("JSON parse failure: {}", error)).map(Pair::getFirst);
    }

    public static PrebuiltStructure fromBytes(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        ResourceLocation structureLocation = buf.m_130281_();
        String name = buf.m_130136_(256);
        String author = buf.m_130136_(256);
        Optional<BlockPos> spawnOverride = buf.readBoolean() ? Optional.of(buf.m_130135_()) : Optional.empty();
        int height = buf.m_130242_();
        ResourceLocation structureSetId = buf.m_130281_();
        ResourceLocation dimensionType = buf.m_130281_();
        ResourceLocation previewImage = buf.m_130281_();
        int displayOrder = buf.m_130242_();
        return new PrebuiltStructure(id, structureLocation, name, author, spawnOverride, structureSetId, height, dimensionType, previewImage, displayOrder);
    }

    public ResourceLocation previewImage() {
        return this.previewImage.equals((Object)DEFAULT_PREVIEW) ? new ResourceLocation(this.id.m_135827_(), "textures/spawn/" + this.id.m_135815_() + ".png") : this.previewImage;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        buf.m_130085_(this.structureLocation);
        buf.m_130070_(this.name);
        buf.m_130070_(this.author);
        buf.writeBoolean(this.spawnOverride.isPresent());
        this.spawnOverride.ifPresent(arg_0 -> ((FriendlyByteBuf)buf).m_130064_(arg_0));
        buf.m_130130_(this.height);
        buf.m_130085_(this.structureSetId);
        buf.m_130085_(this.dimensionType);
        buf.m_130085_(this.previewImage);
        buf.m_130130_(this.displayOrder);
    }

    public boolean matchesName(String match) {
        return match.isEmpty() || this.name.toLowerCase().contains(match.toLowerCase());
    }
}

