/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions.level.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbteamdimensions.FTBDimensionsConfig;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.PrebuiltStructureProvider;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructure;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructureManager;
import dev.ftb.mods.ftbteamdimensions.mixin.ChunkGeneratorAccess;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class MultiBiomeVoidChunkGenerator
extends NoiseBasedChunkGenerator
implements PrebuiltStructureProvider {
    public static final Codec<MultiBiomeVoidChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> MultiBiomeVoidChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and(instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(gen -> gen.noises), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.f_64318_), (App)ResourceLocation.f_135803_.fieldOf("prebuilt_structure_id").forGetter(gen -> gen.prebuiltStructureId))).apply((Applicative)instance, instance.stable(MultiBiomeVoidChunkGenerator::new)));
    protected final BlockState defaultBlock;
    private final Registry<NormalNoise.NoiseParameters> noises;
    private final Aquifer.FluidPicker globalFluidPicker;
    private final ResourceLocation prebuiltStructureId;
    private final HolderSet<StructureSet> startStructure;

    public static MultiBiomeVoidChunkGenerator multiBiomeVoidChunkGen(RegistryAccess registryAccess, ResourceLocation prebuiltStructureId) {
        Registry structureSetRegistry = registryAccess.m_175515_(Registry.f_211073_);
        Registry biomeRegistry = registryAccess.m_175515_(Registry.f_122885_);
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.Preset.f_187087_.m_187099_(biomeRegistry);
        Registry noiseParams = registryAccess.m_175515_(Registry.f_194568_);
        Holder settings = registryAccess.m_175515_(Registry.f_122878_).m_206081_(NoiseGeneratorSettings.f_64432_);
        MultiBiomeVoidChunkGenerator gen = new MultiBiomeVoidChunkGenerator((Registry<StructureSet>)structureSetRegistry, (Registry<NormalNoise.NoiseParameters>)noiseParams, (BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)settings, prebuiltStructureId);
        if (!((Boolean)FTBDimensionsConfig.COMMON_GENERAL.allowVoidFeatureGen.get()).booleanValue()) {
            ((ChunkGeneratorAccess)((Object)gen)).setFeaturesPerStep(List::of);
        }
        return gen;
    }

    private MultiBiomeVoidChunkGenerator(Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, ResourceLocation prebuiltStructureId) {
        super(structureSets, noises, biomeSource, settings);
        this.noises = noises;
        this.prebuiltStructureId = prebuiltStructureId;
        NoiseGeneratorSettings genSettings = (NoiseGeneratorSettings)settings.m_203334_();
        this.defaultBlock = genSettings.f_64440_();
        Aquifer.FluidStatus lava = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int i = genSettings.f_64444_();
        Aquifer.FluidStatus defaultFluid = new Aquifer.FluidStatus(i, genSettings.f_64441_());
        this.globalFluidPicker = (x, y, z) -> y < Math.min(-54, i) ? lava : defaultFluid;
        ResourceLocation structureSetId = PrebuiltStructureManager.getServerInstance().getStructure(prebuiltStructureId).map(PrebuiltStructure::structureSetId).orElse(PrebuiltStructure.DEFAULT_STRUCTURE_SET);
        this.startStructure = structureSets.m_203561_(TagKey.m_203882_((ResourceKey)Registry.f_211073_, (ResourceLocation)structureSetId));
    }

    public Stream<Holder<StructureSet>> m_207969_() {
        return Stream.concat(this.startStructure.m_203614_(), super.m_207969_());
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunk, GenerationStep.Carving step) {
    }

    public void m_214194_(WorldGenRegion level, StructureManager structureManager, RandomState random, ChunkAccess chunk) {
    }

    public void m_6929_(WorldGenRegion level) {
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.f_64318_.m_203334_()).f_64439_().f_64508_();
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState random, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6337_() {
        return ((NoiseGeneratorSettings)this.f_64318_.m_203334_()).f_64444_();
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.f_64318_.m_203334_()).f_64439_().f_158688_();
    }

    public int m_214096_(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState random) {
        return level.m_141937_();
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor height, RandomState random) {
        return new NoiseColumn(height.m_141937_(), new BlockState[0]);
    }

    @Override
    public ResourceLocation getPrebuiltStructureId() {
        return this.prebuiltStructureId;
    }
}

