/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteamdimensions.FTBTeamDimensions;
import dev.ftb.mods.ftbteamdimensions.commands.FTBDimensionsCommands;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DimensionStorage;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DynamicDimensionManager;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructureManager;
import dev.ftb.mods.ftbteamdimensions.event.DimensionCreatedEvent;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum DimensionsManager {
    INSTANCE;

    private static final Logger LOGGER;

    @Nullable
    public ResourceKey<Level> getDimension(Player player) {
        Team playerTeam = FTBTeamsAPI.getPlayerTeam((ServerPlayer)((ServerPlayer)player));
        return this.getDimension(playerTeam);
    }

    @Nullable
    public ResourceKey<Level> getDimension(Team team) {
        if (team.getType() != TeamType.PARTY) {
            return null;
        }
        return DimensionStorage.get(team.manager.server).getDimensionId(team);
    }

    public void createDimForTeam(ServerPlayer player, ResourceLocation prebuiltId) {
        ResourceKey<Level> dimensionId;
        Team playerTeam = FTBTeamsAPI.getPlayerTeam((ServerPlayer)player);
        if (playerTeam.getType() != TeamType.PARTY) {
            try {
                playerTeam = FTBDimensionsCommands.createPartyTeam(player);
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("Unable to create player team due to " + e);
                return;
            }
        }
        if ((dimensionId = DimensionStorage.get(player.f_8924_).getDimensionId(playerTeam)) != null) {
            DynamicDimensionManager.teleport(player, dimensionId);
            return;
        }
        String dimensionName = playerTeam.getId().toString();
        ResourceKey<Level> key = DimensionStorage.get(player.f_8924_).putDimension(playerTeam, dimensionName);
        ServerLevel serverLevel = DynamicDimensionManager.create(player.f_8924_, key, prebuiltId);
        BlockPos spawnPoint = PrebuiltStructureManager.getServerInstance().getStructure(prebuiltId).map(prebuilt -> player.f_8924_.m_236738_().m_230407_(prebuilt.structureLocation()).map(structure -> {
            BlockPos blockPos = prebuilt.spawnOverride().orElse(new BlockPos(0, prebuilt.height(), 0));
            ResourceLocation dimLoc = serverLevel.m_6018_().m_46472_().m_135782_();
            BlockPos spawnPos = DimensionStorage.get(player.f_8924_).getDimensionSpawnLocation(dimLoc);
            if (spawnPos == null) {
                DimensionStorage.get(player.f_8924_).addDimensionSpawn(dimLoc, blockPos);
                FTBTeamDimensions.LOGGER.info("Adding spawnpoint {} to dim storage for {}", (Object)blockPos, (Object)dimLoc);
            }
            return blockPos;
        }).orElse(BlockPos.f_121853_)).orElse(BlockPos.f_121853_);
        player.m_9158_(key, spawnPoint, 0.0f, true, false);
        DynamicDimensionManager.teleport(player, key);
        player.m_150109_().m_6211_();
        player.m_5634_(player.m_21233_());
        FoodData foodData = player.m_36324_();
        foodData.m_150378_(0.0f);
        foodData.m_38705_(20);
        foodData.m_38717_(5.0f);
        MinecraftForge.EVENT_BUS.post((Event)new DimensionCreatedEvent(dimensionName, playerTeam, player, player.f_8924_.m_129880_(key)));
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

