/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.ftb.mods.ftbteamdimensions.FTBDimensionsConfig;
import dev.ftb.mods.ftbteamdimensions.dimensions.DimensionUtils;
import dev.ftb.mods.ftbteamdimensions.dimensions.DimensionsManager;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DimensionStorage;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DynamicDimensionManager;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructureManager;
import dev.ftb.mods.ftbteamdimensions.net.SyncArchivedDimensions;
import dev.ftb.mods.ftbteamdimensions.net.SyncPrebuiltStructures;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class DimensionsMain {
    public static final int SIZE = 128;
    public static final int HEIGHT = 256;
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation OVERWORLD = new ResourceLocation("overworld");

    public static void setup() {
        TeamEvent.PLAYER_LEFT_PARTY.register(DimensionsMain::teamPlayerLeftParty);
        TeamEvent.PLAYER_JOINED_PARTY.register(DimensionsMain::teamPlayerJoin);
        LifecycleEvent.SERVER_STARTED.register(DimensionsMain::serverStart);
        PlayerEvent.PLAYER_JOIN.register(DimensionsMain::syncDimensions);
    }

    private static void syncDimensions(ServerPlayer player) {
        new SyncArchivedDimensions(DimensionStorage.get(player.f_8924_).getArchivedDimensions()).sendTo(player);
        new SyncPrebuiltStructures(PrebuiltStructureManager.getServerInstance()).sendTo(player);
    }

    private static void teamPlayerJoin(PlayerJoinedPartyTeamEvent event) {
        Team team = event.getTeam();
        if (team.getType() != TeamType.PARTY || team.getOwner() == event.getPlayer().m_20148_()) {
            return;
        }
        ResourceKey<Level> dimension = DimensionsManager.INSTANCE.getDimension(team);
        if (dimension == null) {
            return;
        }
        BlockPos blockPos = DimensionStorage.get(event.getPlayer().f_8924_).getDimensionSpawnLocation(dimension.m_135782_());
        if (blockPos != null) {
            event.getPlayer().m_9158_(dimension, blockPos, 0.0f, true, false);
            DynamicDimensionManager.teleport(event.getPlayer(), dimension);
        }
    }

    private static void serverStart(MinecraftServer minecraftServer) {
        ServerLevel level = minecraftServer.m_129880_(Level.f_46428_);
        if (level == null) {
            LOGGER.warn("Missed spawn reset event due to overworld being null");
            return;
        }
        if (DimensionStorage.get(minecraftServer).isLobbySpawned() && !level.m_220360_().equals((Object)DimensionStorage.get(minecraftServer).getLobbySpawnPos())) {
            level.m_8733_(DimensionStorage.get(minecraftServer).getLobbySpawnPos(), 180.0f);
            LOGGER.info("Updating shared spawn to the lobby location");
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent event) {
        if (event.getEntity().f_19853_.m_46472_().equals((Object)Level.f_46428_) && event.getSource() != DamageSource.f_19317_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        MinecraftServer server = serverLevel.m_7654_();
        DimensionStorage dimensionStorage = DimensionStorage.get(server);
        if (!serverLevel.m_46472_().m_135782_().equals((Object)OVERWORLD) || dimensionStorage.isLobbySpawned()) {
            return;
        }
        try {
            ResourceLocation lobbyLocation = FTBDimensionsConfig.COMMON_GENERAL.lobbyLocation();
            if (!serverLevel.m_46472_().m_135782_().equals((Object)OVERWORLD)) {
                BlockPos dimSpawn = dimensionStorage.getDimensionSpawnLocation(serverLevel.m_46472_().m_135782_());
                if (!serverLevel.m_220360_().equals((Object)dimSpawn)) {
                    serverLevel.m_8733_(dimSpawn == null ? BlockPos.f_121853_.m_6630_(1) : dimSpawn, 0.0f);
                }
            }
            StructureTemplate lobby = serverLevel.m_215082_().m_230359_(lobbyLocation);
            StructurePlaceSettings placeSettings = DimensionUtils.makePlacementSettings(lobby);
            BlockPos spawnPos = DimensionUtils.locateSpawn(lobby);
            BlockPos lobbyLoc = BlockPos.f_121853_.m_7918_(-(lobby.m_163801_().m_123341_() / 2), ((Integer)FTBDimensionsConfig.COMMON_GENERAL.lobbyYposition.get()).intValue(), -(lobby.m_163801_().m_123343_() / 2));
            BlockPos playerSpawn = spawnPos.m_7918_(lobbyLoc.m_123341_(), lobbyLoc.m_123342_(), lobbyLoc.m_123343_());
            lobby.m_230328_((ServerLevelAccessor)serverLevel, lobbyLoc, lobbyLoc, placeSettings, serverLevel.f_46441_, 3);
            dimensionStorage.setLobbySpawnPos(playerSpawn);
            dimensionStorage.setLobbySpawned(true);
            serverLevel.m_7471_(playerSpawn, false);
            LOGGER.info("Spawned lobby structure @ {}", (Object)lobbyLoc);
        }
        catch (ResourceLocationException e) {
            LOGGER.error("invalid lobby resource location: " + e.getMessage());
        }
    }

    private static void teamPlayerLeftParty(PlayerLeftPartyTeamEvent event) {
        ServerPlayer serverPlayer = event.getPlayer();
        if (serverPlayer != null) {
            ResourceKey<Level> dimensionId = DimensionStorage.get(event.getPlayer().f_8924_).getDimensionId(event.getTeam());
            if (dimensionId == null) {
                return;
            }
            if (((Boolean)FTBDimensionsConfig.COMMON_GENERAL.clearPlayerInventory.get()).booleanValue()) {
                serverPlayer.m_150109_().m_36022_(arg -> true, -1, (Container)serverPlayer.f_36095_.m_39730_());
                serverPlayer.f_36096_.m_38946_();
                serverPlayer.f_36095_.m_6199_((Container)serverPlayer.m_150109_());
            }
            if (event.getTeamDeleted()) {
                DimensionStorage dimensionStorage = DimensionStorage.get(event.getPlayer().f_8924_);
                dimensionStorage.archiveDimension(event.getTeam());
                new SyncArchivedDimensions(dimensionStorage.getArchivedDimensions()).sendToAll(serverPlayer.f_8924_);
            }
            DynamicDimensionManager.teleport(serverPlayer, (ResourceKey<Level>)Level.f_46428_);
            serverPlayer.m_9158_(Level.f_46428_, DimensionStorage.get(serverPlayer.f_8924_).getLobbySpawnPos(), 180.0f, true, false);
        }
    }

    @SubscribeEvent
    public static void onJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        Level level = event.getLevel();
        if (level.f_46443_ || !((entity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (level.m_46472_().m_135782_().equals((Object)OVERWORLD) && player.m_8963_().m_135782_().equals((Object)OVERWORLD)) {
            BlockPos lobbySpawnPos = DimensionStorage.get(player.f_8924_).getLobbySpawnPos();
            if (player.m_8961_() == null || !player.m_8961_().equals((Object)lobbySpawnPos)) {
                player.m_9158_(level.m_46472_(), lobbySpawnPos, -180.0f, true, false);
                player.m_8999_((ServerLevel)level, (double)lobbySpawnPos.m_123341_(), (double)lobbySpawnPos.m_123342_(), (double)lobbySpawnPos.m_123343_(), -180.0f, -10.0f);
            }
        }
        DimensionsMain.swapGameMode((ResourceKey<Level>)level.m_46472_(), player);
    }

    @SubscribeEvent
    public static void onLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        DimensionsMain.swapGameMode((ResourceKey<Level>)event.getLevel().m_46472_(), player);
    }

    private static void swapGameMode(ResourceKey<Level> dimension, ServerPlayer player) {
        if (dimension.m_135782_().equals((Object)OVERWORLD) && player.f_8941_.m_9290_() != GameType.ADVENTURE && player.f_8941_.m_9290_() != GameType.CREATIVE) {
            player.m_143403_(GameType.ADVENTURE);
        }
        if (!dimension.m_135782_().equals((Object)OVERWORLD) && player.f_8941_.m_9290_() == GameType.ADVENTURE) {
            player.m_143403_(GameType.SURVIVAL);
        }
    }
}

