/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbteamdimensions.FTBDimensionsConfig;
import dev.ftb.mods.ftbteamdimensions.FTBTeamDimensions;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.chunkgen.MultiBiomeVoidChunkGenerator;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.chunkgen.SimpleVoidChunkGenerator;
import dev.ftb.mods.ftbteamdimensions.dimensions.waterlogging.WaterLoggingFixProcessor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DimensionUtils {
    private static final BlockIgnoreProcessor IGNORE_PROCESSOR = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50454_, (Object)Blocks.f_50677_));

    public static BlockPos locateSpawn(StructureTemplate template) {
        StructurePlaceSettings placeSettings = DimensionUtils.makePlacementSettings(template);
        BlockPos spawnPos = BlockPos.f_121853_;
        for (StructureTemplate.StructureBlockInfo info : template.m_74603_(BlockPos.f_121853_, placeSettings, Blocks.f_50677_)) {
            if (info.f_74677_ == null || StructureMode.valueOf((String)info.f_74677_.m_128461_("mode")) != StructureMode.DATA) continue;
            FTBTeamDimensions.LOGGER.info("Found data block at [{}] with data [{}]", (Object)info.f_74675_, (Object)info.f_74677_.m_128461_("metadata"));
            if (!info.f_74677_.m_128461_("metadata").equalsIgnoreCase("spawn_point")) continue;
            spawnPos = info.f_74675_;
        }
        return spawnPos;
    }

    public static StructurePlaceSettings makePlacementSettings(StructureTemplate template) {
        Vec3i size = template.m_163801_();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.m_74392_((Boolean)FTBDimensionsConfig.COMMON_GENERAL.placeEntitiesInStartStructure.get() == false);
        settings.m_74383_((StructureProcessor)IGNORE_PROCESSOR);
        settings.m_74383_((StructureProcessor)WaterLoggingFixProcessor.INSTANCE);
        settings.m_74385_(new BlockPos(size.m_123341_() / 2, size.m_123342_() / 2, size.m_123343_() / 2));
        settings.m_74379_(Rotation.NONE);
        return settings;
    }

    public static boolean isTeamDimension(Level level) {
        return level.m_46472_().m_135782_().m_135827_().equals("ftbteamdimensions");
    }

    public static boolean isPortalDimension(Level level) {
        return (Boolean)FTBDimensionsConfig.COMMON_GENERAL.allowNetherPortals.get() != false && DimensionUtils.isTeamDimension(level);
    }

    public static boolean isVoidChunkGen(ChunkGenerator chunkGenerator) {
        return chunkGenerator instanceof SimpleVoidChunkGenerator || chunkGenerator instanceof MultiBiomeVoidChunkGenerator;
    }
}

