/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class BiomeReplacementUtils {
    public static void replaceBiome(ServerLevel level, ChunkAccess chunk, BlockPos pFrom, BlockPos pTo, Holder<Biome> replacement) {
        BlockPos minPos = BiomeReplacementUtils.quantize(pFrom);
        BlockPos maxPos = BiomeReplacementUtils.quantize(pTo);
        BoundingBox boundingbox = BoundingBox.m_162375_((Vec3i)minPos, (Vec3i)maxPos);
        chunk.m_183442_(BiomeReplacementUtils.makeResolver(chunk, boundingbox, replacement, holder -> true), level.m_7726_().m_214994_().m_224579_());
        chunk.m_8092_(true);
        BiomeReplacementUtils.syncChunkToClients(level, chunk);
    }

    private static BiomeResolver makeResolver(ChunkAccess pChunk, BoundingBox pTargetRegion, Holder<Biome> pReplacementBiome, Predicate<Holder<Biome>> pFilter) {
        return (x, y, z, sampler) -> {
            int i = QuartPos.m_175402_((int)x);
            int j = QuartPos.m_175402_((int)y);
            int k = QuartPos.m_175402_((int)z);
            Holder holder = pChunk.m_203495_(x, y, z);
            return pTargetRegion.m_71051_((Vec3i)new BlockPos(i, j, k)) && pFilter.test(holder) ? pReplacementBiome : holder;
        };
    }

    private static void syncChunkToClients(ServerLevel serverLevel, ChunkAccess chunk) {
        LevelChunk lc;
        ChunkPos chunkpos = chunk.m_7697_();
        LevelChunk levelchunk = chunk instanceof LevelChunk ? (lc = (LevelChunk)chunk) : serverLevel.m_6325_(chunkpos.f_45578_, chunkpos.f_45579_);
        serverLevel.m_7726_().f_8325_.m_183262_(chunkpos, false).forEach(player -> player.f_8906_.m_9829_((Packet)new ClientboundLevelChunkWithLightPacket(levelchunk, serverLevel.m_5518_(), null, null, true)));
    }

    private static int quantize(int pValue) {
        return QuartPos.m_175402_((int)QuartPos.m_175400_((int)pValue));
    }

    private static BlockPos quantize(BlockPos pPos) {
        return new BlockPos(BiomeReplacementUtils.quantize(pPos.m_123341_()), BiomeReplacementUtils.quantize(pPos.m_123342_()), BiomeReplacementUtils.quantize(pPos.m_123343_()));
    }
}

