/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.data;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.nethersdelight.common.block.BlackstoneStoveBlock;
import umpaz.nethersdelight.common.block.FungusColonyBlock;
import umpaz.nethersdelight.common.registry.NDBlocks;

public class NDBlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public NDBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "nethersdelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.richSoulSoilBlock((Block)NDBlocks.RICH_SOUL_SOIL.get());
        this.horizontalBlock((Block)NDBlocks.BLACKSTONE_STOVE.get(), state -> {
            String name = this.blockName((Block)NDBlocks.BLACKSTONE_STOVE.get());
            String suffix = "";
            if (((Boolean)state.m_61143_((Property)BlackstoneStoveBlock.SOUL)).booleanValue()) {
                suffix = "_soul";
            }
            if (!((Boolean)state.m_61143_((Property)BlackstoneStoveBlock.SOUL)).booleanValue() && ((Boolean)state.m_61143_((Property)BlackstoneStoveBlock.LIT)).booleanValue()) {
                suffix = "_on";
            }
            return this.models().orientableWithBottom(name + suffix, this.resourceBlock(name + "_side"), this.resourceBlock(name + "_front" + suffix), this.resourceBlock(name + "_bottom"), this.resourceBlock(name + "_top" + suffix));
        });
        this.horizontalBlock((Block)NDBlocks.BLACKSTONE_FURNACE.get(), state -> {
            String name = this.blockName((Block)NDBlocks.BLACKSTONE_FURNACE.get());
            String suffix = (Boolean)state.m_61143_((Property)FurnaceBlock.f_48684_) != false ? "_on" : "";
            return this.models().orientable(name + suffix, this.resourceBlock(name + "_side"), this.resourceBlock(name + "_front" + suffix), this.resourceBlock(name + "_top"));
        });
        this.horizontalBlock((Block)NDBlocks.NETHER_BRICK_SMOKER.get(), state -> {
            String name = this.blockName((Block)NDBlocks.NETHER_BRICK_SMOKER.get());
            String suffix = (Boolean)state.m_61143_((Property)SmokerBlock.f_48684_) != false ? "_on" : "";
            return this.models().orientableWithBottom(name + suffix, this.resourceBlock(name + "_side"), this.resourceBlock(name + "_front" + suffix), this.resourceBlock(name + "_bottom"), this.resourceBlock(name + "_top"));
        });
        this.horizontalBlock((Block)NDBlocks.BLACKSTONE_BLAST_FURNACE.get(), state -> {
            String name = this.blockName((Block)NDBlocks.BLACKSTONE_BLAST_FURNACE.get());
            String suffix = (Boolean)state.m_61143_((Property)BlastFurnaceBlock.f_48684_) != false ? "_on" : "";
            return this.models().orientable(name + suffix, this.resourceBlock(name + "_side"), this.resourceBlock(name + "_front" + suffix), this.resourceBlock(name + "_top"));
        });
        this.stageBlock((Block)NDBlocks.CRIMSON_FUNGUS_COLONY.get(), FungusColonyBlock.COLONY_AGE, new Property[0]);
        this.stageBlock((Block)NDBlocks.WARPED_FUNGUS_COLONY.get(), FungusColonyBlock.COLONY_AGE, new Property[0]);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("nethersdelight", "block/" + path);
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String var10000 = this.blockName(block);
            String stageName = var10000 + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void richSoulSoilBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().cubeTop(this.blockName(block), this.resourceBlock("soul_compost_0"), this.resourceBlock("rich_soul_soil")));
    }
}

