/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.concurrent.atomic.AtomicReference;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Dim2iExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.ScrollBarComponent;
import me.jellysquid.mods.sodium.client.util.Dim2i;

public class ScrollableFrame
extends AbstractFrame {
    protected final Dim2i frameOrigin;
    protected final AbstractFrame frame;
    private boolean canScrollHorizontal;
    private boolean canScrollVertical;
    private Dim2i viewPortDimension = null;
    private ScrollBarComponent verticalScrollBar = null;
    private ScrollBarComponent horizontalScrollBar = null;

    public ScrollableFrame(Dim2i dim, AbstractFrame frame, boolean renderOutline, AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        super(dim, renderOutline);
        this.frame = frame;
        this.frameOrigin = new Dim2i(frame.dim.x(), frame.dim.y(), 0, 0);
        this.setupFrame(verticalScrollBarOffset, horizontalScrollBarOffset);
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame(AtomicReference<Integer> verticalScrollBarOffset, AtomicReference<Integer> horizontalScrollBarOffset) {
        int maxWidth = 0;
        int maxHeight = 0;
        if (!((Dim2iExtended)this.dim).canFitDimension(this.frame.dim)) {
            int value;
            if (this.dim.getLimitX() < this.frame.dim.getLimitX() && maxWidth < (value = this.frame.dim.x() - this.dim.x() + this.frame.dim.width())) {
                maxWidth = value;
            }
            if (this.dim.getLimitY() < this.frame.dim.getLimitY() && maxHeight < (value = this.frame.dim.y() - this.dim.y() + this.frame.dim.height())) {
                maxHeight = value;
            }
        }
        if (maxWidth > 0) {
            this.canScrollHorizontal = true;
        }
        if (maxHeight > 0) {
            this.canScrollVertical = true;
        }
        if (this.canScrollHorizontal && this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height() - 11);
        } else if (this.canScrollHorizontal) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height() - 11);
            ((Dim2iExtended)this.frame.dim).setHeight(this.frame.dim.height() - 11);
        } else if (this.canScrollVertical) {
            this.viewPortDimension = new Dim2i(this.dim.x(), this.dim.y(), this.dim.width() - 11, this.dim.height());
            ((Dim2iExtended)this.frame.dim).setWidth(this.frame.dim.width() - 11);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.x(), this.viewPortDimension.getLimitY() + 1, this.viewPortDimension.width(), 10), ScrollBarComponent.Mode.HORIZONTAL, this.frame.dim.width(), this.viewPortDimension.width(), offset -> {
                this.buildFrame();
                horizontalScrollBarOffset.set((Integer)offset);
            });
            this.horizontalScrollBar.setOffset(horizontalScrollBarOffset.get());
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar = new ScrollBarComponent(new Dim2i(this.viewPortDimension.getLimitX() + 1, this.viewPortDimension.y(), 10, this.viewPortDimension.height()), ScrollBarComponent.Mode.VERTICAL, this.frame.dim.height(), this.viewPortDimension.height(), offset -> {
                this.buildFrame();
                verticalScrollBarOffset.set((Integer)offset);
            }, this.viewPortDimension);
            this.verticalScrollBar.setOffset(verticalScrollBarOffset.get());
        }
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.updateThumbPosition();
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.updateThumbPosition();
        }
        if (this.canScrollHorizontal) {
            ((Dim2iExtended)this.frame.dim).setX(this.frameOrigin.x() - this.horizontalScrollBar.getOffset());
        }
        if (this.canScrollVertical) {
            ((Dim2iExtended)this.frame.dim).setY(this.frameOrigin.y() - this.verticalScrollBar.getOffset());
        }
        this.frame.buildFrame();
        this.children.add(this.frame);
        super.buildFrame();
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.canScrollHorizontal || this.canScrollVertical) {
            if (this.renderOutline) {
                this.drawRectOutline(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
            }
            this.applyScissor(this.viewPortDimension.x(), this.viewPortDimension.y(), this.viewPortDimension.width(), this.viewPortDimension.height(), () -> super.m_6305_(matrices, mouseX, mouseY, delta));
        } else {
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
        if (this.canScrollHorizontal) {
            this.horizontalScrollBar.m_6305_(matrices, mouseX, mouseY, delta);
        }
        if (this.canScrollVertical) {
            this.verticalScrollBar.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button) || this.canScrollHorizontal && this.horizontalScrollBar.m_6375_(mouseX, mouseY, button) || this.canScrollVertical && this.verticalScrollBar.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || this.canScrollHorizontal && this.horizontalScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || this.canScrollVertical && this.verticalScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button) || this.canScrollHorizontal && this.horizontalScrollBar.m_6348_(mouseX, mouseY, button) || this.canScrollVertical && this.verticalScrollBar.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return super.m_6050_(mouseX, mouseY, amount) || this.canScrollHorizontal && this.horizontalScrollBar.m_6050_(mouseX, mouseY, amount) || this.canScrollVertical && this.verticalScrollBar.m_6050_(mouseX, mouseY, amount);
    }

    public static class Builder {
        private boolean renderOutline = false;
        private Dim2i dim = null;
        private AbstractFrame frame = null;
        private AtomicReference<Integer> verticalScrollBarOffset = new AtomicReference<Integer>(0);
        private AtomicReference<Integer> horizontalScrollBarOffset = new AtomicReference<Integer>(0);

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean state) {
            this.renderOutline = state;
            return this;
        }

        public Builder setVerticalScrollBarOffset(AtomicReference<Integer> verticalScrollBarOffset) {
            this.verticalScrollBarOffset = verticalScrollBarOffset;
            return this;
        }

        public Builder setHorizontalScrollBarOffset(AtomicReference<Integer> horizontalScrollBarOffset) {
            this.horizontalScrollBarOffset = horizontalScrollBarOffset;
            return this;
        }

        public Builder setFrame(AbstractFrame frame) {
            this.frame = frame;
            return this;
        }

        public ScrollableFrame build() {
            return new ScrollableFrame(this.dim, this.frame, this.renderOutline, this.verticalScrollBarOffset, this.horizontalScrollBarOffset);
        }
    }
}

