/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sunekaer.toolkit.ToolkitPlatform;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CommandOreDist {
    private static final DecimalFormat FORMATTER = new DecimalFormat("########0.00");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"oredist").requires(cs -> cs.m_6761_(0))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.toolkit.oredist.missing"));
            return 1;
        })).then(Commands.m_82129_((String)"AreaSize", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandOreDist.getOreDist((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"AreaSize"))));
    }

    private static int getOreDist(CommandSourceStack source, Player player, int size) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        double searchSize = 16 * size >> 1;
        double startX = player.m_20182_().f_82479_ - searchSize;
        double startZ = player.m_20182_().f_82481_ - searchSize;
        double endX = player.m_20182_().f_82479_ + searchSize;
        double endZ = player.m_20182_().f_82481_ + searchSize;
        Level world = player.m_9236_();
        for (int y = world.m_141937_(); y < world.m_151558_(); ++y) {
            for (double x2 = startX; x2 < endX; x2 += 1.0) {
                for (double z = startZ; z < endZ; z += 1.0) {
                    BlockPos tBlockPos = new BlockPos(x2, (double)y, z);
                    BlockState tBlockState = world.m_8055_(tBlockPos);
                    Block tBlock = tBlockState.m_60734_();
                    if (tBlock.equals(Blocks.f_50016_) || tBlock.equals(Blocks.f_50752_) || tBlock.equals(Blocks.f_50069_) || tBlock.equals(Blocks.f_50493_) || tBlock.equals(Blocks.f_49990_) || !tBlock.m_204297_().m_203656_(ToolkitPlatform.getOresTag())) continue;
                    ResourceLocation key1 = Registry.f_122824_.m_7981_((Object)tBlock);
                    String key = Objects.requireNonNull(key1).toString();
                    Object value = map.get(key1.toString());
                    if (value != null) {
                        map.put(key, (Integer)map.get(key) + 1);
                        continue;
                    }
                    map.put(key, 1);
                }
            }
        }
        double sum = map.values().stream().reduce(0, Integer::sum).intValue();
        if (sum == 0.0) {
            source.m_81354_((Component)Component.m_237115_((String)"\u00a7c No ores found"), true);
            return 1;
        }
        map.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(x -> source.m_81354_((Component)Component.m_237115_((String)("\u00a7c" + (String)x.getKey() + " \u00a7rCount: " + x.getValue() + " (" + FORMATTER.format((double)((Integer)x.getValue() * 100) / sum) + "%%)")), true));
        return 1;
    }
}

