/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.function.BiPredicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.StringRepresentableArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import org.jetbrains.annotations.NotNull;

public class CommandKill {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kill").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"type", (ArgumentType)KillTypeArgument.killType()).executes(context -> CommandKill.kill(KillTypeArgument.getKillType((CommandContext<CommandSourceStack>)context, "type"), (CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"by").then(Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> CommandKill.killByEntity((CommandContext<CommandSourceStack>)context, EntitySummonArgument.m_93338_((CommandContext)context, (String)"entity")))));
    }

    private static int killByEntity(CommandContext<CommandSourceStack> context, ResourceLocation entityId) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        EntityType entityType = (EntityType)Registry.f_122826_.m_7745_(entityId);
        if (entityType == null) {
            return -1;
        }
        source.m_81354_((Component)Component.m_237110_((String)"commands.toolkit.kill.start", (Object[])new Object[]{entityId}), true);
        int entitiesKilled = CommandKill.yeetEntities((player, entity) -> entity.m_6095_().equals(entityType), level, (Player)source.m_81375_());
        CommandKill.yeetedEntitiesMessage(source, entitiesKilled, entityId.toString());
        return 0;
    }

    private static int kill(KillType type, CommandSourceStack source) throws CommandSyntaxException {
        ServerLevel level = source.m_81372_();
        int entitiesKilled = 0;
        String typeName = Component.m_237115_((String)("commands.toolkit.kill.type." + type.name())).getString();
        source.m_81354_((Component)Component.m_237110_((String)"commands.toolkit.kill.start", (Object[])new Object[]{typeName}), true);
        if (type == KillType.me || type == KillType.players) {
            for (Player player : level.m_8795_(e -> type.checker.test((Player)e, (Entity)e))) {
                player.m_6074_();
                ++entitiesKilled;
            }
        } else {
            entitiesKilled += CommandKill.yeetEntities(type.checker, level, (Player)source.m_81375_());
        }
        CommandKill.yeetedEntitiesMessage(source, entitiesKilled, typeName);
        return 1;
    }

    private static void yeetedEntitiesMessage(CommandSourceStack source, int yeetedAmount, String typeName) {
        if (yeetedAmount > 0) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.toolkit.kill.done", (Object[])new Object[]{yeetedAmount}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"commands.toolkit.kill.no", (Object[])new Object[]{typeName}), true);
        }
    }

    private static int yeetEntities(BiPredicate<Player, Entity> tester, ServerLevel level, Player player) {
        int entitiesKilled = 0;
        for (Entity entity : level.m_8583_()) {
            if (entity == null || !tester.test(player, entity)) continue;
            entity.m_142687_(Entity.RemovalReason.KILLED);
            ++entitiesKilled;
        }
        return entitiesKilled;
    }

    public static class KillTypeArgument
    extends StringRepresentableArgument<KillType> {
        protected KillTypeArgument() {
            super(KillType.CODEC, KillType::values);
        }

        public static KillTypeArgument killType() {
            return new KillTypeArgument();
        }

        public static KillType getKillType(CommandContext<CommandSourceStack> source, String name) {
            return (KillType)((Object)source.getArgument(name, KillType.class));
        }
    }

    static enum KillType implements StringRepresentable
    {
        all((p, entity) -> !(entity instanceof AbstractMinecart) && !entity.m_20148_().equals(p.m_20148_())),
        animals((p, entity) -> entity instanceof Animal),
        monsters((p, entity) -> entity instanceof Monster),
        items((p, entity) -> entity instanceof ItemEntity),
        xp((p, entity) -> entity instanceof ExperienceOrb),
        players((p, entity) -> entity instanceof Player),
        me((p, entity) -> entity instanceof Player && entity.m_20148_().equals(p.m_20148_()));

        final BiPredicate<Player, Entity> checker;
        public static final Codec<KillType> CODEC;

        private KillType(BiPredicate<Player, Entity> checker) {
            this.checker = checker;
        }

        @NotNull
        public String m_7912_() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.m_216439_(KillType::values);
        }
    }
}

