/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.sunekaer.toolkit.utils.EnchantmentHacks;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ItemEnchantmentArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public class CommandEnchant {
    public static final SimpleCommandExceptionType ERROR_MISSING_PLAYER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.toolkit.failed.missing_player"));
    private static final Dynamic2CommandExceptionType ERROR_MISSING_ENCHANTMENT = new Dynamic2CommandExceptionType((a, b) -> Component.m_237110_((String)"commands.toolkit.enchant.failed.missing_enchant", (Object[])new Object[]{a, b}));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.enchant.failed.incompatible", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.enchant.failed.itemless", (Object[])new Object[]{object}));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"enchant").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"enchantment", (ArgumentType)ItemEnchantmentArgument.m_95260_()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CommandEnchant.enchant((CommandContext<CommandSourceStack>)context, ItemEnchantmentArgument.m_95263_((CommandContext)context, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"enchantment", (ArgumentType)ItemEnchantmentArgument.m_95260_()).executes(context -> CommandEnchant.removeEnchantment((CommandContext<CommandSourceStack>)context, ItemEnchantmentArgument.m_95263_((CommandContext)context, (String)"enchantment")))));
    }

    private static int enchant(CommandContext<CommandSourceStack> context, Enchantment enchantment, int level) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_230896_();
        ItemStack mainHandItem = CommandEnchant.getItemInHand(player);
        if (mainHandItem == null) {
            throw ERROR_MISSING_PLAYER.create();
        }
        if (!enchantment.m_6081_(mainHandItem) || !EnchantmentHelper.m_44859_(EnchantmentHelper.m_44831_((ItemStack)mainHandItem).keySet(), (Enchantment)enchantment)) {
            throw ERROR_INCOMPATIBLE.create((Object)mainHandItem.m_41720_().m_7626_(mainHandItem).getString());
        }
        EnchantmentHacks.enchantItem(mainHandItem, enchantment, (short)level);
        source.m_81354_((Component)Component.m_237110_((String)"commands.toolkit.enchant.success", (Object[])new Object[]{mainHandItem.m_41720_().m_7626_(mainHandItem).getString(), enchantment.m_44700_(level).getString()}), false);
        return 1;
    }

    private static int removeEnchantment(CommandContext<CommandSourceStack> context, Enchantment enchantment) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_230896_();
        ItemStack mainHandItem = CommandEnchant.getItemInHand(player);
        if (mainHandItem == null) {
            throw ERROR_MISSING_PLAYER.create();
        }
        if (!EnchantmentHelper.m_44831_((ItemStack)mainHandItem).containsKey(enchantment)) {
            throw ERROR_MISSING_ENCHANTMENT.create((Object)mainHandItem.m_41720_().m_7626_(mainHandItem).getString(), (Object)enchantment.m_44700_(1));
        }
        boolean success = EnchantmentHacks.removeEnchantment(mainHandItem, enchantment);
        if (success) {
            source.m_81354_((Component)Component.m_237110_((String)"commands.toolkit.remove_enchant.success", (Object[])new Object[]{mainHandItem.m_41720_().m_7626_(mainHandItem).getString(), enchantment.m_44700_(1).getString()}), false);
        } else {
            source.m_81352_((Component)Component.m_237110_((String)"commands.toolkit.remove_enchant.failed", (Object[])new Object[]{mainHandItem.m_41720_().m_7626_(mainHandItem).getString(), enchantment.m_44700_(1).getString()}));
        }
        return success ? 1 : 0;
    }

    @Nullable
    public static ItemStack getItemInHand(@Nullable ServerPlayer player) throws CommandSyntaxException {
        if (player == null) {
            return null;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_41619_()) {
            throw ERROR_NO_ITEM.create((Object)player.m_7755_().getString());
        }
        return mainHandItem;
    }
}

