/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.container;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.network.container.ContainerData;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class ComputerContainerData
implements ContainerData {
    private final ComputerFamily family;
    private final TerminalState terminal;
    private final ItemStack displayStack;

    public ComputerContainerData(ServerComputer computer, @Nonnull ItemStack displayStack) {
        this.family = computer.getFamily();
        this.terminal = computer.getTerminalState();
        this.displayStack = displayStack;
    }

    public ComputerContainerData(FriendlyByteBuf buf) {
        this.family = (ComputerFamily)buf.m_130066_(ComputerFamily.class);
        this.terminal = new TerminalState(buf);
        this.displayStack = buf.m_130267_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.family);
        this.terminal.write(buf);
        buf.writeItemStack(this.displayStack, true);
    }

    public ComputerFamily family() {
        return this.family;
    }

    public TerminalState terminal() {
        return this.terminal;
    }

    @Nonnull
    public ItemStack displayStack() {
        return this.displayStack;
    }
}

