/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.ErrorFactory;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaThread;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.NonResumableException;
import cc.tweaked.internal.cobalt.OperationHelper;
import cc.tweaked.internal.cobalt.UnwindThrowable;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.compiler.LoadState;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.debug.DebugHandler;
import cc.tweaked.internal.cobalt.debug.DebugState;
import cc.tweaked.internal.cobalt.function.LibFunction;
import cc.tweaked.internal.cobalt.function.LuaFunction;
import cc.tweaked.internal.cobalt.function.RegisteredFunction;
import cc.tweaked.internal.cobalt.function.ResumableVarArgFunction;
import cc.tweaked.internal.cobalt.function.ZeroArgFunction;
import cc.tweaked.internal.cobalt.lib.LuaLibrary;
import cc.tweaked.internal.cobalt.lib.UncheckedLuaError;
import java.io.InputStream;

public class BaseLib
implements LuaLibrary {
    private static final LuaString STDIN_STR = ValueFactory.valueOf("=stdin");
    private static final LuaString FUNCTION_STR = ValueFactory.valueOf("function");
    private static final LuaString LOAD_MODE = ValueFactory.valueOf("bt");
    private LuaValue next;
    private LuaValue inext;
    private static final String[] LIBR_KEYS = new String[]{"pcall", "xpcall", "load"};

    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        env.rawset("_G", (LuaValue)env);
        env.rawset("_VERSION", (LuaValue)ValueFactory.valueOf("Luaj 0.0"));
        RegisteredFunction.bind(env, env, new RegisteredFunction[]{RegisteredFunction.of("collectgarbage", BaseLib::collectgarbage), RegisteredFunction.of("error", BaseLib::error), RegisteredFunction.of("setfenv", BaseLib::setfenv), RegisteredFunction.ofV("assert", BaseLib::assert_), RegisteredFunction.ofV("dofile", BaseLib::dofile), RegisteredFunction.ofV("getfenv", BaseLib::getfenv), RegisteredFunction.ofV("getmetatable", BaseLib::getmetatable), RegisteredFunction.ofV("loadfile", BaseLib::loadfile), RegisteredFunction.ofV("loadstring", BaseLib::loadstring), RegisteredFunction.ofV("print", BaseLib::print), RegisteredFunction.ofV("select", BaseLib::select), RegisteredFunction.ofV("unpack", BaseLib::unpack), RegisteredFunction.ofV("type", BaseLib::type), RegisteredFunction.ofV("rawequal", BaseLib::rawequal), RegisteredFunction.ofV("rawget", BaseLib::rawget), RegisteredFunction.ofV("rawset", BaseLib::rawset), RegisteredFunction.ofV("setmetatable", BaseLib::setmetatable), RegisteredFunction.ofV("tostring", BaseLib::tostring), RegisteredFunction.ofV("tonumber", BaseLib::tonumber), RegisteredFunction.ofV("pairs", this::pairs), RegisteredFunction.ofV("ipairs", this::ipairs), RegisteredFunction.ofV("rawlen", BaseLib::rawlen), RegisteredFunction.ofV("next", BaseLib::next)});
        LibFunction.bind(env, () -> new BaseLibR(), LIBR_KEYS);
        this.next = env.rawget("next");
        this.inext = RegisteredFunction.ofV("inext", BaseLib::inext).create(env);
        env.rawset("_VERSION", (LuaValue)ValueFactory.valueOf("Lua 5.1"));
        return env;
    }

    private static LuaValue collectgarbage(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        String s;
        switch (s = arg1.optString("collect")) {
            case "collect": {
                System.gc();
                return Constants.ZERO;
            }
            case "count": {
                Runtime rt = Runtime.getRuntime();
                long used = rt.totalMemory() - rt.freeMemory();
                return ValueFactory.valueOf((double)used / 1024.0);
            }
            case "step": {
                System.gc();
                return Constants.TRUE;
            }
        }
        throw ErrorFactory.argError(1, "invalid option");
    }

    private static LuaValue error(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        throw new LuaError(arg1.isNil() ? Constants.NIL : arg1, arg2.optInteger(1));
    }

    private static LuaValue setfenv(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        LuaTable t = arg2.checkTable();
        LuaValue f = BaseLib.getfenvobj(state, arg1);
        if (!f.isThread() && !f.isClosure()) {
            throw new LuaError("'setfenv' cannot change environment of given object");
        }
        f.setfenv(t);
        return f.isThread() ? Constants.NONE : f;
    }

    private static LuaValue getfenvobj(LuaState state, LuaValue arg) throws LuaError {
        if (arg.isFunction()) {
            return arg;
        }
        int level = arg.optInteger(1);
        Varargs.argCheck(level >= 0, 1, "level must be non-negative");
        if (level == 0) {
            return state.getCurrentThread();
        }
        LuaFunction f = LuaThread.getCallstackFunction(state, level - 1);
        Varargs.argCheck(f != null, 1, "invalid level");
        return f;
    }

    private static Varargs assert_(LuaState state, Varargs args) throws LuaError {
        if (!args.first().toBoolean()) {
            throw new LuaError(args.count() > 1 ? args.arg(2).optString("assertion failed!") : "assertion failed!");
        }
        return args;
    }

    private static Varargs dofile(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        Varargs v;
        Varargs varargs = v = args.isNil(1) ? BaseLib.loadStream(state, state.stdin, STDIN_STR) : BaseLib.loadFile(state, args.arg(1).checkString());
        if (v.isNil(1)) {
            throw new LuaError(v.arg(2).toString());
        }
        return OperationHelper.invoke(state, v.first(), Constants.NONE);
    }

    private static Varargs getfenv(LuaState state, Varargs args) throws LuaError {
        LuaValue f = BaseLib.getfenvobj(state, args.first());
        LuaTable e = f.getfenv();
        return e != null ? e : Constants.NIL;
    }

    private static Varargs getmetatable(LuaState state, Varargs args) throws LuaError {
        LuaTable mt = args.checkValue(1).getMetatable(state);
        return mt != null ? mt.rawget(Constants.METATABLE).optValue(mt) : Constants.NIL;
    }

    private static Varargs loadfile(LuaState state, Varargs args) throws LuaError {
        return args.isNil(1) ? BaseLib.loadStream(state, state.stdin, STDIN_STR) : BaseLib.loadFile(state, args.arg(1).checkString());
    }

    private static Varargs loadstring(LuaState state, Varargs args) throws LuaError {
        LuaString script = args.arg(1).checkLuaString();
        return BaseLib.loadStream(state, script.toInputStream(), args.arg(2).optLuaString(script));
    }

    private static Varargs print(LuaState state, Varargs args) throws LuaError {
        return OperationHelper.noUnwind(state, () -> {
            LuaValue tostring = OperationHelper.getTable(state, state.getCurrentThread().getfenv(), ValueFactory.valueOf("tostring"));
            int n = args.count();
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    state.stdout.write(9);
                }
                LuaString s = OperationHelper.call(state, tostring, args.arg(i)).strvalue();
                int z = s.indexOf((byte)0, 0);
                state.stdout.write(s.bytes, s.offset, z >= 0 ? z : s.length);
            }
            state.stdout.println();
            return Constants.NONE;
        });
    }

    private static Varargs select(LuaState state, Varargs args) throws LuaError {
        int n = args.count() - 1;
        if (args.first().equals(ValueFactory.valueOf("#"))) {
            return ValueFactory.valueOf(n);
        }
        int i = args.arg(1).checkInteger();
        if (i == 0 || i < -n) {
            throw ErrorFactory.argError(1, "index out of range");
        }
        return args.subargs(i < 0 ? n + i + 2 : i + 1);
    }

    private static Varargs unpack(LuaState state, Varargs args) throws LuaError {
        int i;
        int na = args.count();
        LuaTable t = args.arg(1).checkTable();
        int n = t.length();
        int j = na >= 3 ? args.arg(3).optInteger(n) : n;
        n = j - (i = na >= 2 ? args.arg(2).optInteger(1) : 1) + 1;
        if (n < 0) {
            return Constants.NONE;
        }
        if (n == 1) {
            return t.rawget(i);
        }
        if (n == 2) {
            return ValueFactory.varargsOf(t.rawget(i), (Varargs)t.rawget(j));
        }
        LuaValue[] v = new LuaValue[n];
        for (int k = 0; k < n; ++k) {
            v[k] = t.rawget(i + k);
        }
        return ValueFactory.varargsOf(v);
    }

    private static Varargs type(LuaState state, Varargs args) throws LuaError {
        return ValueFactory.valueOf(args.checkValue(1).typeName());
    }

    private static Varargs rawequal(LuaState state, Varargs args) throws LuaError {
        return ValueFactory.valueOf(args.checkValue(1) == args.checkValue(2));
    }

    private static Varargs rawget(LuaState state, Varargs args) throws LuaError {
        return args.arg(1).checkTable().rawget(args.checkValue(2));
    }

    private static Varargs rawset(LuaState state, Varargs args) throws LuaError {
        LuaTable t = args.arg(1).checkTable();
        LuaValue k = args.checkValue(2);
        LuaValue v = args.checkValue(3);
        if (k.isNil()) {
            throw new LuaError("table index is nil");
        }
        t.rawset(k.checkValidKey(), v);
        return t;
    }

    private static Varargs setmetatable(LuaState state, Varargs args) throws LuaError {
        LuaValue t = args.first();
        LuaTable mt0 = t.getMetatable(state);
        if (mt0 != null && !mt0.rawget(Constants.METATABLE).isNil()) {
            throw new LuaError("cannot change a protected metatable");
        }
        LuaValue mt = args.checkValue(2);
        t.setMetatable(state, mt.isNil() ? null : mt.checkTable());
        return t;
    }

    private static Varargs tostring(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        return OperationHelper.toString(state, args.checkValue(1));
    }

    private static Varargs tonumber(LuaState state, Varargs args) throws LuaError {
        LuaValue arg1 = args.checkValue(1);
        int base = args.arg(2).optInteger(10);
        if (base == 10) {
            return arg1.toNumber();
        }
        if (base < 2 || base > 36) {
            throw ErrorFactory.argError(2, "base out of range");
        }
        return arg1.checkLuaString().tonumber(base);
    }

    private Varargs pairs(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        LuaValue value = args.checkValue(1);
        LuaValue pairs = value.metatag(state, Constants.PAIRS);
        if (pairs.isNil()) {
            return ValueFactory.varargsOf(this.next, value, (Varargs)Constants.NIL);
        }
        return OperationHelper.invoke(state, pairs, value);
    }

    private Varargs ipairs(LuaState state, Varargs args) throws LuaError {
        return ValueFactory.varargsOf(this.inext, (LuaValue)args.arg(1).checkTable(), (Varargs)Constants.ZERO);
    }

    private static Varargs rawlen(LuaState state, Varargs args) throws LuaError {
        LuaValue v = args.arg(1);
        switch (v.type()) {
            case 5: {
                return ValueFactory.valueOf(v.checkTable().length());
            }
            case 4: {
                return ValueFactory.valueOf(v.checkLuaString().length);
            }
        }
        throw ErrorFactory.argError(1, "table or string expected");
    }

    private static Varargs next(LuaState state, Varargs args) throws LuaError {
        return args.arg(1).checkTable().next(args.arg(2));
    }

    private static Varargs inext(LuaState state, Varargs args) throws LuaError {
        return args.arg(1).checkTable().inext(args.arg(2));
    }

    private static Varargs pcall(LuaState state, DebugFrame di, LuaValue func, Varargs args, LuaValue errFunc) throws UnwindThrowable {
        PCallState pState = new PCallState();
        di.state = pState;
        di.flags |= 0x10;
        pState.frame = di;
        LuaValue oldErr = pState.oldErrorFunc = state.getCurrentThread().setErrorFunc(errFunc);
        try {
            Varargs result = ValueFactory.varargsOf((LuaValue)Constants.TRUE, OperationHelper.invoke(state, func, args));
            state.getCurrentThread().setErrorFunc(oldErr);
            return result;
        }
        catch (Exception | VirtualMachineError e) {
            DebugHandler.getDebugState((LuaState)state).getStackUnsafe().flags |= 0x400;
            pState.errored = true;
            LuaError le = LuaError.wrap(e);
            le.fillTraceback(state);
            state.getCurrentThread().setErrorFunc(oldErr);
            BaseLib.closeUntil(state, di);
            return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)le.value);
        }
    }

    private static void closeUntil(LuaState state, DebugFrame top) {
        DebugFrame current;
        DebugState ds = DebugHandler.getDebugState(state);
        DebugHandler handler = state.debug;
        while ((current = ds.getStackUnsafe()) != top) {
            current.cleanup();
            handler.onReturnError(ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Varargs loadFile(LuaState state, String filename) {
        InputStream is = state.resourceManipulator.findResource(filename);
        if (is == null) {
            return ValueFactory.varargsOf(Constants.NIL, (Varargs)ValueFactory.valueOf("cannot open " + filename + ": No such file or directory"));
        }
        try {
            Varargs varargs = BaseLib.loadStream(state, is, ValueFactory.valueOf("@" + filename));
            return varargs;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Varargs loadStream(LuaState state, InputStream is, LuaString chunkname) {
        try {
            if (is == null) {
                return ValueFactory.varargsOf(Constants.NIL, (Varargs)ValueFactory.valueOf("not found: " + chunkname));
            }
            return LoadState.load(state, is, chunkname, state.getCurrentThread().getfenv());
        }
        catch (Exception e) {
            return ValueFactory.varargsOf(Constants.NIL, (Varargs)LuaError.getMessage(e));
        }
    }

    private static class StringInputStream
    extends InputStream {
        private final LuaState state;
        final LuaValue func;
        byte[] bytes;
        int offset;
        int remaining = 0;

        StringInputStream(LuaState state, LuaValue func) {
            this.state = state;
            this.func = func;
        }

        @Override
        public int read() {
            if (this.remaining <= 0) {
                LuaString ls;
                LuaValue s;
                try {
                    s = OperationHelper.noUnwind(this.state, () -> OperationHelper.call(this.state, this.func));
                }
                catch (LuaError e) {
                    throw new UncheckedLuaError(e);
                }
                if (s.isNil()) {
                    return -1;
                }
                try {
                    ls = s.strvalue();
                }
                catch (LuaError e) {
                    throw new UncheckedLuaError(e);
                }
                this.bytes = ls.bytes;
                this.offset = ls.offset;
                this.remaining = ls.length;
                if (this.remaining <= 0) {
                    return -1;
                }
            }
            --this.remaining;
            return this.bytes[this.offset++];
        }
    }

    private static final class PCallState {
        DebugFrame frame;
        LuaValue oldErrorFunc;
        boolean errored = false;

        private PCallState() {
        }
    }

    private static class BaseLibR
    extends ResumableVarArgFunction<PCallState> {
        private BaseLibR() {
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            switch (this.opcode) {
                case 0: {
                    return BaseLib.pcall(state, di, args.checkValue(1), args.subargs(2), null);
                }
                case 1: {
                    return BaseLib.pcall(state, di, args.checkValue(1), Constants.NONE, args.checkValue(2));
                }
                case 2: {
                    LuaValue scriptGen = args.arg(1);
                    final LuaString chunkName = args.arg(2).optLuaString(null);
                    final LuaString mode = args.arg(3).optLuaString(LOAD_MODE);
                    final LuaTable funcEnv = args.arg(4).optTable(state.getCurrentThread().getfenv());
                    LuaValue script = scriptGen.toLuaString();
                    if (!script.isNil()) {
                        try {
                            return LoadState.load(state, ((LuaString)script).toInputStream(), chunkName == null ? (LuaString)script : chunkName, mode, funcEnv);
                        }
                        catch (Exception e) {
                            return ValueFactory.varargsOf(Constants.NIL, (Varargs)LuaError.getMessage(e));
                        }
                    }
                    final LuaFunction function = scriptGen.checkFunction();
                    Varargs result = BaseLib.pcall(state, di, new ZeroArgFunction(){

                        @Override
                        public LuaValue call(LuaState state) throws LuaError {
                            try {
                                StringInputStream stream = new StringInputStream(state, function);
                                return LoadState.load(state, stream, chunkName == null ? FUNCTION_STR : chunkName, mode, funcEnv);
                            }
                            catch (Exception e) {
                                throw LuaError.wrapMessage(e);
                            }
                        }
                    }, Constants.NONE, state.getCurrentThread().getErrorFunc());
                    if (result.first().toBoolean()) {
                        return result.arg(2);
                    }
                    return ValueFactory.varargsOf(Constants.NIL, (Varargs)result.arg(2));
                }
            }
            return Constants.NONE;
        }

        @Override
        protected Varargs resumeThis(LuaState state, PCallState pState, Varargs value) {
            state.getCurrentThread().setErrorFunc(pState.oldErrorFunc);
            if (pState.errored) {
                BaseLib.closeUntil(state, pState.frame);
            }
            return this.finish(pState, value);
        }

        @Override
        public Varargs resumeErrorThis(LuaState state, PCallState pState, LuaError error) throws UnwindThrowable {
            LuaValue value;
            if (pState.errored) {
                value = ValueFactory.valueOf("error in error handling");
            } else {
                DebugHandler.getDebugState((LuaState)state).getStackUnsafe().flags |= 0x400;
                pState.errored = true;
                error.fillTraceback(state);
                value = error.value;
            }
            state.getCurrentThread().setErrorFunc(pState.oldErrorFunc);
            BaseLib.closeUntil(state, pState.frame);
            return this.finish(pState, value);
        }

        private Varargs finish(PCallState pState, Varargs value) {
            switch (this.opcode) {
                case 0: 
                case 1: {
                    return pState.errored ? ValueFactory.varargsOf((LuaValue)Constants.FALSE, value) : ValueFactory.varargsOf((LuaValue)Constants.TRUE, value);
                }
                case 2: {
                    return pState.errored ? ValueFactory.varargsOf(Constants.NIL, value) : value;
                }
            }
            throw new NonResumableException("Cannot resume " + this.debugName());
        }
    }
}

